#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("loadpred", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;

    my $pipe = "";
    
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	my @dirs = ( "ema",
		     "actual",
		     "target",
		     "high",
		     "low",
		     "system-mean",
		     "system-stddev",
		     #"numreplicas-detailed",
		   );

	foreach my $d (@dirs) {
	    system("rm -rf $outdir/$out/$d/$exp");
	    system("mkdir -p $outdir/$out/$d/$exp");
	}
	
	print STDERR "### Expt -- $exp...\n";
	
	my $start    = GetStartTime($dir);
	my $slowdown = GetSlowDown($dir);
	my @files;
	if ($AGGLOGS) {
		@files = glob("$dir/AggregateMessage*");
	} else {
		@files = glob "$dir/Message*";
	}

	chdir $dir;
	foreach my $f (@files) {
	    $f =~ /(\d+\.\d+\.\d+\.\d+\:\d+)/;
	    my $id = $1;
	    die "bad filename $f" if !$id;

	    my $shopts = "-S $start -s $SKIPTIME -l $LENGTH";
	    my $field = 0;

	    $field = 1 if (!$AGGLOGS);
	    
	    if ($slowdown != 1) {
		$pipe = "$ENV{HOME}/Colyseus/scripts/TimeFilter.pl -S $start -w $slowdown -f $field |";		
	    }
	    
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe cut -f1,2 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/ema/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe cut -f1,3 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/actual/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe cut -f1,4 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/target/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe ~/Colyseus/scripts/Cut++.pl -f1,4+5 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/high/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe ~/Colyseus/scripts/Cut++.pl -f1,4-5 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/low/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe cut -f1,6 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/system-mean/$exp/$id.log");
	    system("cat LoadEstimateAccuracyLog.$id.log | $pipe cut -f1,7 | ~/Colyseus/scripts/TimeFilter.pl $shopts > $outdir/$out/system-stddev/$exp/$id.log");
	    
	}
    }
}
