#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("load", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	my @dirs = ( "highlow"
		   );

	foreach my $d (@dirs) {
	    system("rm -rf $outdir/$out/$d/$exp");
	    system("mkdir -p $outdir/$out/$d/$exp");
	}
	
	print STDERR "### Expt -- $exp...\n";
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowdown ($dir);
	my @files = glob "$dir/Message*";

	chdir $dir;
	foreach my $f (@files) {
	    $f =~ /(\d+\.\d+\.\d+\.\d+\:\d+)/;
	    my $id = $1;
	    die "bad filename $f" if !$id;
	    
	    system ("~/Colyseus/scripts/TimeFilter.pl -w $slowdown -S $start -s $SKIPTIME -l $LENGTH $f | ~/Colyseus/scripts/OMLoadHighLowWater.pl > $outdir/$out/highlow/$exp/$id.log");
	}
    }
}
