#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("hops", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    if (!$APPEND) {
	system("rm -rf $outdir/$out");
    }
    system("mkdir -p $outdir/$out");
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "### Expt -- $exp...\n";

	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my @files = glob "$dir/DiscoveryLat*";
	
	my $cmd;

	$cmd = "$ENV{HOME}/Colyseus/scripts/HopStats.pl -S $start -s $SKIPTIME -l $LENGTH ";
	if ($slowdown > 1.0) { 
	    $cmd .= " -w $slowdown ";
	}
	system ("$cmd @files >$outdir/$out/$exp");
	
	if ($? & 127) { 
	    print STDERR "signal caught. exiting.\n";
	    exit ($?);
	}
    }
}

