#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("framerates", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    if (!$APPEND) {
	system("rm -f $outdir/$out");
    }
    open F, ">>$outdir/$out" or die $!;
    print F  "NODE\tMEDIAN\tMEAN\tSTDDEV\t99%\t95%\n", "="x80, "\n";
    close F;

    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	print STDERR "### Expt -- $exp... dir=$dir\n";
	open(F, ">>$outdir/$out") || die $!;
	print F "Experiment = $exp\n", "="x80, "\n";
	close(F);
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	
	chdir ($dir);
	my $cmd = "$ENV{HOME}/Colyseus/scripts/FrameRates.pl -S $start -s $SKIPTIME -l $LENGTH ";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}
	
	system ("$cmd >> $outdir/$out");
    }
}
