#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("bwidth-individual", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    system("rm -rf $outdir/$out");
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	print STDERR "-- Exp $out $exp\n";
	system("mkdir -p $outdir/$out/$exp");
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	my @files = glob "$dir/Message*";

	foreach my $f (@files) {
	    $f =~ /(\d+\.\d+\.\d+\.\d+\:\d+)/;
	    my $id = $1;
	    
	    system ("./ExpMsgLogTmSeries.pl -w $slowdown $LOGARGS -S $start -s $SKIPTIME -l $LENGTH -e 1 -t proto -T $f > $outdir/$out/$exp/$id.dat");
	}
    }
}
