#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use ResultsConf;

Runall("bwidth-detail", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    system("rm -f $outdir/$out");
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "Expt -- $exp...\n";
	open(F, ">>$outdir/$out") || die $!;
	print F "Experiment = $exp\n", "="x80, "\n";
	close(F);
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
        my @files;
        if (!$AGGLOGS) {
	   @files = glob "$dir/Message*";
        } else {
           @files = glob "$dir/AggregateMessage*";
        }
	
	my $cmd;
	if (!$AGGLOGS) {
	    $cmd = "$ENV{HOME}/Colyseus/scripts/MessageLogAggregate.pl -b -S $start -s $SKIPTIME -l $LENGTH -w $slowdown ";
	}
	else {
	    $cmd = "$ENV{HOME}/Colyseus/scripts/AggMsgLogAggregate.pl -S $start -s $SKIPTIME -l $LENGTH -w $slowdown ";
	}
	system ("$cmd @files >> $outdir/$out");
    }
}
