#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use lib "$ENV{HOME}/Colyseus/run";
BEGIN {
    $ENV{TRAVERTINE_PRINTCMDS} = 1;
};
use Travertine;
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("bwidth", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    if (!$APPEND) {
	system("rm -f $outdir/$out");
    }
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];

	print STDERR "### Expt -- $exp...\n";
	open(F, ">>$outdir/$out") || die $!;
	print F "Experiment = $exp\n", "="x80, "\n";
	close(F);
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	
	my @files;
	if ($AGGLOGS) {
	    @files = glob "$dir/AggregateMessage*";
	}
	else {
	    @files = glob "$dir/Message*";
	}

	my $cmd = "$ENV{HOME}/Colyseus/scripts/ExpMsgLogTmSeries.pl $LOGARGS -S $start -s $SKIPTIME -l $LENGTH -e 1 -t proto -T ";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}
	
	system ("$cmd @files >> $outdir/$out");
    }
}
