#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("csbc", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $out = shift;
    my @expts = @_;
    
    my $cs = "client-server.dat";
    my $bc = "bcast.dat";
    if (!$APPEND) { 
	system ("rm -f $outdir/$cs $outdir/$bc");
    }

    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "Expt -- $exp...\n";
	foreach my $f ($cs, $bc) { 
	    open(F, ">>$outdir/$f") || die $!;
	    print F "Experiment = $exp\n", "="x80, "\n";
	    close(F);
	}
	
	my $slowdown = GetSlowDown ($dir);
	foreach my $etype ('client-server', 'bcast') { 
	    my ($type) = ($etype =~ /(.)/);
	    my @files = glob "$outdir/$etype/$out/$exp/*";	    

	    my $cmd = "$ENV{HOME}/Colyseus/scripts/CSBMsgLogTmSeries.pl -t $type -s 0 -e 1 -T ";
	    if ($slowdown > 1.0) { 
		$cmd .= " -w $slowdown ";
	    }
	    system "$cmd @files >> $outdir/$etype.dat";
	}
    }

}
