#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use Getopt::Std;
use vars qw($opt_a);
use ResultsConf;

getopts ("a");
our $APPEND = defined $opt_a;
Runall("csbc", \&DoIt);

sub DoIt {
    my $outdir = shift;
    my $grp = shift;
    my @expts = @_;
    
    system("mkdir -p $outdir/client-server");
    system("mkdir -p $outdir/bcast"); 
    foreach my $pair (@expts) 
    {
	my $exp = $pair->[0];
	my $dir = $pair->[1];
	
	print STDERR "Expt -- $exp...\n";
	
	chdir $dir;
	
	my $start = GetStartTime($dir);
	my $slowdown = GetSlowDown ($dir);
	
	system("rm -rf $outdir/client-server/$grp/$exp");
	system("mkdir -p $outdir/client-server/$grp/$exp");
	# my $cmd = "$ENV{HOME}/Colyseus/scripts/ClientServerSim.pl -S $start -s $SKIPTIME -l $LENGTH ";
	my $cmd = "$ENV{HOME}/Colyseus/scripts/clisersim -S $start -s $SKIPTIME -l $LENGTH ";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}

	system "$cmd > $outdir/client-server/$grp/$exp/client-server.log";
	
	system("rm -rf $outdir/bcast/$grp/$exp");
	system("mkdir -p $outdir/bcast/$grp/$exp");

	$cmd = "$ENV{HOME}/Colyseus/scripts/clisersim -S $start -s $SKIPTIME -l $LENGTH -b -o $outdir/bcast/$grp/$exp/";
	if ($slowdown > 1.0) {
	    $cmd .= " -w $slowdown ";
	}

	system "$cmd";
    }
}
