#
# Configuration for results processing
#

package ResultsConf;

use strict;
use lib "$ENV{HOME}/Colyseus/run";
use lib "$ENV{HOME}/Colyseus/scripts";
use Travertine;
require Exporter;

our @ISA    = ("Exporter");
our @EXPORT = qw($logdir $resdir Runall GetStartTime GetSlowDown
		 @EXPTS $SKIPTIME $LENGTH $AGGLOGS $LOGARGS);

our $logdir;
our $resdir;
our @EXPTS;
our $SKIPTIME;
our $LENGTH;
our $SLOWDOWN;
our $AGGLOGS;

require "$ENV{HOME}/Colyseus/scripts/ResultsConf.pl";

###############################################################################

#
# Runall(\&DoIt, $out [, @expts ])
#
# \&DoIt  - DoIt function taking (outdir, group_name, @exp_dir_list)
# $out    - results created in "$resdir/$out" directory
# @expts  - optional list of experiments (default: @EXPTS)
#
sub Runall($$@) {
    my $out = shift;
    my $DoIt = shift;
    my @todo;
    if (@_ == 0) {
	@todo = @EXPTS;
    } else {
	@todo = @_;
    }

    if (! -d $logdir) {
	tdie "log directory does not exist: $logdir";
    }

    foreach my $todo (@todo) {
	tinfo "==================== $todo->[0] ====================";
	psystem("mkdir -p $resdir/$out") && 
	    tdie "failed to make directory $resdir/$out";
	$DoIt->("$resdir/$out", $todo->[0], @{$todo->[1]});
    }

    return;
}

sub GetStartTime($) {
    my $expdir = shift;

    if (! -d $expdir) {
        tdie "no such directory: $expdir";
    }

    my @files;
    my $field;
    if (!$AGGLOGS) {
        @files = glob "$expdir/Message*";
        $field = 2;
    } else {
        @files = glob "$expdir/AggregateMessage*";
        $field = 1;
    }
    my $start = `~/Colyseus/scripts/MaxStartTime.pl -f$field @files`;
    chomp $start;

    if (!$start) {
	if (@files == 0) { 
	    tdie "no Message logs in directory: $expdir";
	}
	else {
	    # perhaps this is a one-server setting in which no messages would
	    # get sent. how does one obtain the start time then?
	    $start = `head -1 $expdir/ObjectDelta* | awk '{ print \$1 }'`;
	    chomp $start;
	}
    }

    return $start;
}

sub GetSlowDown($) {
    my $expdir = shift;

    if (! -d $expdir) {
        tdie "no such directory: $expdir";
    }
    my $file = `ls $expdir/OutputLog.* | grep -v bootstrap | head -1`;
    chomp $file;

    tdie " no OutputLog in $expdir" if $file eq "";
    $SLOWDOWN = `grep -- slowdown-factor: $file | awk '{ print \$NF }'`;    
    chomp $SLOWDOWN;

    # tinfo "slowdown is taken care of automatically; slowdown=1.000";
    return 1.0;

#    print "slowdown=$SLOWDOWN\n";
#    tdie " no slowdown factor defined in outputlog? " if (!defined $SLOWDOWN || $SLOWDOWN eq "");
#    
#    if ($SLOWDOWN < 1.0) {
#	$SLOWDOWN = 1.0;
#    }
#	    
#    return $SLOWDOWN;
}

1;
