
###############################################################################
#
# Directories
#

our $logdir = defined $ENV{COL_RESULTS_LOGDIR} ? 
    $ENV{COL_RESULTS_LOGDIR} : 
    "/home/jeffpang/sosp2005/mon-night";
our $resdir = defined $ENV{COL_RESULTS_RESDIR} ? 
    $ENV{COL_RESULTS_RESDIR} : 
    "/home/jeffpang/sosp2005/results";

###############################################################################
#
# Experiment sets
#

our %exp_points = (
		   "nodes" => defined $ENV{COL_RESULTS_NODES} ?
		   [ split(/,/, $ENV{COL_RESULTS_NODES}) ] :
		   [ 5,10,20,30,40,50 ],

		   "scaling" => defined $ENV{COL_RESULTS_SCALING} ?
		   [ split(/,/, $ENV{COL_RESULTS_SCALING}) ] :
		   [ 20,40,50,80,100 ],

		   "dht" => defined $ENV{COL_RESULTS_DHT} ?
		   [ split(/,/, $ENV{COL_RESULTS_DHT}) ] :
		   [ 5,10,20,30,40,50 ],

		   "components" => defined $ENV{COL_RESULTS_COMPONENTS} ?
		   [ split(/,/, $ENV{COL_RESULTS_COMPONENTS}) ] :
		   [ "nocache","noprediction","noprediction-nocache",
		     "nostriping","item-partition-r" ],

		   "p2p" => defined $ENV{COL_RESULTS_P2P} ?
		   [ split(/,/, $ENV{COL_RESULTS_P2P}) ] :
		   [ 3,5,7,10,20,30,40,50,100 ],
		   );

our %exp_pointdirs;

$exp_pointdirs{nodes} = 
    [ map { [$_ => "$logdir/nodes/$_"] } @{$exp_points{nodes}} ];

$exp_pointdirs{scaling} =
    [ map { [$_ => "$logdir/server_scaling/$_"] } @{$exp_points{scaling}} ];

$exp_pointdirs{dht} =
    [ map { [$_ => "$logdir/dht-cache/$_"] } @{$exp_points{dht}} ];

$exp_pointdirs{components} = 
    [ map { [$_ => "$logdir/component/$_"] } @{$exp_points{components}} ];

$exp_pointdirs{dhtnocache} =
    [ ["dhtnocache" => "$logdir/dht-nocache"] ];

$exp_pointdirs{p2p} =
    [ map { [$_ => "$logdir/p2p/$_"] } @{$exp_points{p2p}} ];

###############################################################################

our @EXPTS;

if (defined $ENV{COL_RESULTS_EXPTS}) {
    foreach my $e (split(/,/, $ENV{COL_RESULTS_EXPTS})) {
	if (defined $exp_pointdirs{$e}) {
	    push @EXPTS, [ $e, $exp_pointdirs{$e} ];
	} else {
	    tdie "bad experiment set in COL_RESULTS_EXPTS: $e";
	}
    }
} else {
    @EXPTS = ( 
	       #[ "nodes", $exp_pointdirs{nodes} ],
	       #[ "scaling", \@scaling ],
	       #[ "dht", \@dht ],
	       #[ "components", \@components ],
	       #[ "dhtnocache", \@dhtnocache ],
	       [ "p2p", $exp_pointdirs{p2p} ],
	     );
}

###############################################################################
#
# Common config parameters
#

our $SKIPTIME = defined $ENV{COL_RESULTS_SKIPTIME} ? $ENV{COL_RESULTS_SKIPTIME} : 60;  # sec (realtime)
our $LENGTH   = defined $ENV{COL_RESULTS_LENGTH} ? $ENV{COL_RESULTS_LENGTH} : 6000; # sec (realtime)
our $SLOWDOWN  = defined $ENV{COL_RESULTS_SLOWDOWN} ? $ENV{COL_RESULTS_SLOWDOWN} : 2; # exp times are X times slower than real time

our $AGGLOGS = defined $ENV{COL_RESULTS_AGGLOGS} ? $ENV{COL_RESULTS_AGGLOGS} : 1;
our $LOGARGS = $AGGLOGS ? "-A" : "-b";

###############################################################################

1;
