#!/usr/bin/perl

use strict;
use Statistics::Descriptive;
use ResultsConf;

die "usage: prog <exp> <point> <fudge>\n" if @ARGV != 3;

my $exp   = $ARGV[0];
my $pt    = $ARGV[1];
my $fudge = $ARGV[2];

my @fields = (0, 1);
my @types  = ('P', 'M');

my $EXPDIR = "$logdir/$exp/$pt";
my $RESDIR = "$resdir/rep-consistency-detail/$fudge/$exp/$pt";

print STDERR "expdir: $EXPDIR\n";
print STDERR "resdir: $RESDIR\n";

my @stats;
for (my $i=0; $i<@fields; $i++) {
    $stats[$i] = new Statistics::Descriptive::Full();
}

open(P, "$ENV{HOME}/Colyseus/scripts/MapGUIDListToType.pl -f2,3 -g $EXPDIR $RESDIR/*.out |") or die "$!";
while (<P>) {
    chomp;
    if (/[^ \t]+\t([\d,]*)\t([\d,]*)/) {
	my ($miss, $req) = ($1, $2);
	my @miss = split /,/, $miss;
	my @req  = split /,/, $req;

	for (my $i=0; $i<@fields; $i++) {
	    if (!defined $miss[$fields[$i]] ||
		!defined $req[$fields[$i]]) {
		warn "missing field $fields[$i]: $_";
		next;
	    }
	    my $s = $req[$i] > 0 ? $miss[$i]/$req[$i] : 0;
	    $stats[$i]->add_data($s);
	}
    } else {
	warn "bad line: $!";
    }
}
close(P);

for (my $i=0; $i<@fields; $i++) {
    my $t = $types[$i];
    my $stat = $stats[$i];

    my $mean = sprintf "%.5f", $stat->mean();
    my $std  = sprintf "%.5f", $stat->standard_deviation();
    my $med = sprintf "%.5f", $stat->median();
    my $ninefive = sprintf "%.5f", $stat->percentile(95);
    my $ninenine = sprintf "%.5f", $stat->percentile(99);
    my $nineninenine = sprintf "%.5f", $stat->percentile(99.9);
    
    print "$t MEAN    $mean\n";
    print "$t STDDEV  $std\n";
    print "$t MEDIAN  $med\n";
    print "$t 95%     $ninefive\n";
    print "$t 99%     $ninenine\n";
    print "$t 99.9%   $nineninenine\n";
}
