#!/usr/bin/perl
use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use lib "$ENV{HOME}/Colyseus/run";
use Getopt::Std;
use Statistics::Descriptive;
use Travertine;
use vars qw($opt_d $opt_a);

getopts ("d:a");
our $DIR = defined $opt_d ? $opt_d : ".";
our $ABSOLUTE = defined $opt_a;

my $stat = Statistics::Descriptive::Full->new();

foreach my $log (glob("$DIR/*")) {
    my $fields;
    if ($ABSOLUTE) {
	$fields = "2,4";
    } else {
	$fields = "4,5";
    }

    open(D, "cut -f $fields $log |") || die "can't open pipe to $log";
    while (<D>) {
	chomp $_;
	die "bad line: $_" if $_ !~ /\d/;
	my ($needed, $point);

	if ($ABSOLUTE) {
	    ($point, $needed) = split(/\t/, $_);
	} else {
	    ($needed, $point) = split(/\t/, $_);
	}
	next if $needed == 0;

	$stat->add_data($point);
    }
    close(D);
}

if ($stat->count() == 0) {
    $stat->add_data( 0 );
}

my $mean = sprintf "%.5f", $stat->mean();
my $std  = sprintf "%.5f", $stat->standard_deviation();
my $med = sprintf "%.5f", $stat->median();
my $ninefive = sprintf "%.5f", $stat->percentile(95);
my $ninenine = sprintf "%.5f", $stat->percentile(99);
my $nineninenine = sprintf "%.5f", $stat->percentile(99.9);

print"MEAN\t$mean\n";
print "STDDEV\t$std\n";
print "MEDIAN\t$med\n";
print "95%\t$ninefive\n";
print "99%\t$ninenine\n";
print "99.9%\t$nineninenine\n";

