#!/usr/bin/perl
#
# -a  - show all (instead of mean/stddev/95%)
#

use strict;
use lib "$ENV{HOME}/Colyseus/run";
use Travertine;
use Statistics::Descriptive;
use Getopt::Std;
use vars qw($opt_S $opt_a $opt_s $opt_l $opt_d $opt_i);

our %InfoTypes    =  ( 'i' => 'OBJINFO' );
our %CreateTypes  =  ( 'm' => 'MCREATE',
		       'c' => 'DCREATE',
		       'p' => 'PCREATE',
		       'f' => 'FCREATE', );
our %StoreTypes   =  ( 's' => 'STORE' );
our %DestroyTypes =  ( 'y' => 'MDESTROY',
		       'd' => 'TDESTROY',
		       'e' => 'EDESTROY' );

getopts("aS:s:l:d:i:");

our $SHOWALL  = defined $opt_a;
our $START    = defined $opt_S ? $opt_S : undef;
our $SKIPTIME = defined $opt_s ? $opt_s : 0;
our $LENGTH   = defined $opt_l ? $opt_l : undef;
our $DIR      = defined $opt_d ? $opt_d : ".";
our $INTERVAL = defined $opt_i ? $opt_i : 1;

###############################################################################

ProcessLogs(@ARGV);

###############################################################################

sub ProcessLogs(@)
{
    my @files = @_;

    my %tracked  = ();
    #my @results  = ();

    print STDERR "processing logs: ";

    # first-pass: find aliases and messages to track
    foreach my $f (@files) {
        if ($f =~ /\.gz/) {
            open(F, "zcat $f |") || die "can't open pipe to $f";
        } else {
	    open(F, "<$f") || die "can't open $f";
        }
	my($start, $end, $sample);
	$start = $START;
	$sample = $start + $SKIPTIME + $INTERVAL;

	%tracked = ();

	while (<F>) {
	    chomp $_;

	    my ($time, $guid, $type) = ($_ =~ /^([^\t]+)\t([^\t]+)\t([^\t]+)/);
	    
	    if (!defined $start) {
		$start = $time;
		$sample = $start + $SKIPTIME + $INTERVAL;
	    }
	    if ( $time < $start + $SKIPTIME) {
		next;
	    }
	    if (defined $LENGTH && $time > $start + $SKIPTIME + $LENGTH) {
		last;
	    }
	    if ($time > $end) {
		$end = $time;
	    }

	    while ($time >= $sample) {
		Sample($sample, \%tracked);
		$sample += $INTERVAL;
	    }

	    if ($InfoTypes{$type}) {
		$tracked{$guid} = {};
		$tracked{$guid}->{INFO} = [$time, $type];
	    } elsif (defined $tracked{$guid}) {
		if ($CreateTypes{$type}) {
		    if (!defined $tracked{$guid}->{INFO}) {
			warn "no info but got create! $guid";
		    }
		    $tracked{$guid}->{CREATE} = [$time, $type];
		} elsif ($StoreTypes{$type}) {
		    #if (!defined $tracked{$guid}->{CREATE}) {
		#	warn "no create but got store! $guid";
		#    }
		    $tracked{$guid}->{STORE} = [$time, $type];
		} elsif ($DestroyTypes{$type}) {
		    if (!defined $tracked{$guid}->{INFO}) {
			warn "no info but got delete! $guid";
		    }
		    # if we didn't create it, ignore the interest since
		    # we probably decided that we weren't really interested
		    # in it.
		    if (defined $tracked{$guid}->{CREATE}) {
			$tracked{$guid}->{DELETE} = [$time, $type];
			
			#push @results, Output($guid, $tracked{$guid});
		    }
		    delete $tracked{$guid};
		} else {
		    warn "unknown type: $type\n";
		}
	    } else {
		#warn "here: $guid '$type'\n";
	    }
	}

	print STDERR ".";
    }

    print STDERR "\n";

    #return @results;
}

sub Sample {
    my $time = shift;
    my $t = shift;

    my %addrs = ();

    my ($k);
    while (($k,undef) = each %$t) {
	my $a = join(":", (split(/:/, $k))[0..1]);
	$addrs{$a} = 1;
    }

    my $count = scalar keys %addrs;
    print "$time\t$count\n";
}

#sub Output($$)
#{
#    my $guid = shift;
#    my $ref  = shift;
#
#    return [ $guid, $ref->{INFO}, $ref->{CREATE}, $ref->{STORE}, $ref->{DELETE} ];
#}
