#!/usr/bin/perl
use strict;
use Travertine;
use lib "$ENV{HOME}/Colyseus/scripts";
use ScriptDriver;
use Getopt::Std;
use Options;

use vars qw($opt_s $REGEXPS $EXPT $EXPTSET $POINTS $LOGDIR $RESDIR $LIST $ORDER);

my @options = (
    Options::String ('s', 'scripts', '[comma-separated list] of scripts to run', \$opt_s, "FrameRates"),
    Options::Boolean ('r', 'regexp', 'treat scripts as regexp-patterns', \$REGEXPS),
    Options::String ('e', 'expt', '[name,logdir]', \$EXPT, ""),
    Options::String ('E', 'exptset', '[name] expt-set name', \$EXPTSET, ""),
    Options::String ('p', 'points', '[comma-separated expt points]', \$POINTS, ""),
    Options::String ('l', 'logdir', '[dir] top directory for the expt-set logs', \$LOGDIR, ""),
    Options::String ('R', 'resdir', '[dir] results-dir (def=logdir/results)', \$RESDIR, ""),
    Options::Boolean ('L', 'listscripts', 'list available scripts', \$LIST),
    Options::String ('o', 'order', '(s)cripts-first | (e)xpts-first', \$ORDER, 's'),
);

@ARGV = ProcessOptions (\@options, \@ARGV, -complain => 1);

our $SCRIPTS = $opt_s;
$SCRIPTS = "" if ($SCRIPTS =~ /^all$/i);
our $EXACTMATCH = defined $REGEXPS ? 0 : 1;

if ($LIST) { 
    my @scripts = ScriptDriver::GetScripts ("", $EXACTMATCH);
    foreach my $sc (@scripts) { 
	eval { 
	    my $class = "Colyseus::Script::$sc";
	    my $obj = $class->new ();
	};
	if ($@) {
	    print STDERR "* $sc\n";
	}
	else {
	    print STDERR "$sc\n";
	}
    }
    tinfo "* => Not implemented or buggy";
    exit 0;
}
#################################################################################################

if ($EXPT ne "") { 
    my ($name, $dir) = split (/,/, $EXPT);
    my $expt = new Colyseus::Expt (
	$name, $dir, "$dir/results", 
	-scripts => $SCRIPTS, -exactmatch => $EXACTMATCH
    );

    $expt->RunScripts ();

}
elsif ($EXPTSET ne "") {
    tdie ("-l,--logdir and -p,--points must be defined") if ($LOGDIR eq "" or $POINTS eq "");
    my @points = split (/,/, $POINTS);
    my @expts  = map { [ $_, "$LOGDIR/$_" ] } @points;

    if ($RESDIR eq '') {
	$RESDIR = "$LOGDIR/results";
    }
    my $set = new Colyseus::ExptSet (
	$EXPTSET, 
	\@expts,
	$RESDIR,
	-scripts => $SCRIPTS, -exactmatch => $EXACTMATCH, -order => $ORDER,
    );

    $set->RunScripts ();
}
