#!/usr/bin/perl
#
# Print message log
#  $Id: PrintMessageLog.pl 1779 2005-03-19 04:46:07Z ashu $
#
# -b     - the log is binary

use strict;
use Getopt::Std;
use vars qw($opt_b);

my $basedir;
chomp ($basedir = `dirname $0`);
require "$basedir/Common.pl";

getopts("b");

our $LOG_BINARY = defined $opt_b;

###############################################################################

our %MsgTypes = ParseMessageHeader($0);
ProcessInput(@ARGV);

###############################################################################

sub ProcessInput(@)
{
    my @files = @_;

    foreach my $f (@files) {
	print ">>>> $f\n";
	if ($LOG_BINARY) {
	    open F, "$basedir/ParseMessageLog $f |" or die "can't open pipe from file $f";
	}
	else {
	    open(F, "<$f") || die "can't open $f";
	}

	while (<F>) {
	    chomp $_;
	    m/([0-9A-F]{8}?)\t(\d+\.\d+)\t(\d+)\t(\d+)\t(\d+)\t(\d+)/;

	    my $nonce = $1;
	    my $time = $2;
	    my $dir = $3;
	    my $proto = $4;
	    my $type = $5;
	    my $size = $6;
	    
#my ($nonce, $time, $dir, $proto, $type, $size) = split(/\t/, $_);
# print "nonce=$nonce time=$time dir=$dir proto=$proto type=$MsgTypes{$type} size=$size\n";
	    
	    $dir   = $dir   == 0 ? "IN" : "OUT";
	    $proto = $proto == 0 ? "TCP" : "UDP";
	    $type  = $MsgTypes{$type} || $type;

	    print sprintf ("$time %3s %3s %15s %4d\n", $dir, $proto, $type, $size);
	}
    }
}
