#!/usr/bin/perl
#
# Generate a nice plot of a few messagelogs
#
# -s num   - skip the first x seconds of the trace
# -l num   - the length of time to aggregate over (ignore remainder)
# -e epoch - size of each aggregation epoch (sec -- floating point)

use strict;
use Getopt::Std;
use vars qw($opt_s $opt_l $opt_e $opt_o $opt_a);

my $basedir;
chomp ($basedir = `dirname $0`);
require "$basedir/CommonPlot.pl";
require "$basedir/Common.pl";

getopts ("s:l:e:o:a");

our $SKIPTIME = defined $opt_s ? $opt_s : 120;
our $LENGTH   = defined $opt_l ? $opt_l : 600;
our $EPOCH    = defined $opt_e ? $opt_e : 1;
our $OUTPUT   = defined $opt_o ? $opt_o : "tm";
our $AGGLOG = defined $opt_a;

my $files = join " ", @ARGV;
die "no files given?" if ($files =~ /^\s*$/) ;

open F, ">/tmp/post-process" or die "$!";
print F <<EOT;
BEGIN { \$b = 0; } 
\$b = \$F[0] if (\$b == 0);
\$v = \$F[0] - \$b;
print "\$v \$F[1]\\n";
EOT
close F;

foreach my $dir ("in", "out") { 
    begin_plot ('graphtype' => 'eps', 'xlabel' => 'time in epochs', 'ylabel' => 'bw (in kbps)', 
	    dothis => "set terminal postscript eps color\nset grid ytics\n");

    my $logproc = "MessageLogTimeSeries.pl";
    $logproc = "AggMsgLogTimeSeries.pl" if $AGGLOG;

    my $cmd = "$basedir/$logproc -s $SKIPTIME -l $LENGTH -e $EPOCH -d $dir ";
    my $post = "perl -an /tmp/post-process";

    psystem ("$cmd $files | $post > /tmp/plot.1");
    plot (data => "/tmp/plot.1", using => "1:2", with => "linespoints", title => "all");

    psystem ("$cmd -r $files | $post > /tmp/plot.2");
    plot (data => "/tmp/plot.2", using => "1:2", with => "linespoints", title => "routing");
    
    psystem ("$cmd -c $files | $post > /tmp/plot.3");
    plot (data => "/tmp/plot.3", using => "1:2", with => "linespoints", title => "matching");
    
    commit_plot ("$OUTPUT.$dir");
}
