#!/usr/bin/perl
#
# Usage: PlotLoadBalance.pl [time_series files]
#
# Quick and dirty script to plot the load balance on a set of time series
# files.


use strict;
use lib "$ENV{HOME}/Colyseus/scripts";
use lib "$ENV{HOME}/Colyseus/scripts/lib";
use ResultsConf;
use Getopt::Std;
use Statistics::Descriptive;
use vars qw($opt_g $opt_f $opt_c $opt_l $opt_E);

getopts("g:f:c:l:E");

my @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());
#my $AVG_EPOCH = $opt_e;
#my $RESCALE   = !$opt_R;
#my $BWIDTH_BREAKDOWN_POINT = $opt_b;
#my $KEY = !$opt_K;
my $FIELD = defined $opt_f ? $opt_f : 1;
my $LENGTH = $opt_l;
my $ERRORBARS = !$opt_E;

my @sets = ();

my $main_title = "avg. load";
my @files;

if ($opt_c) {
    # comparing multiple
    my @dirs = split(/,/, $opt_c);

    foreach my $d (@dirs) {
	my @f = glob("$d/*.log");
	die "no files in $d" if !@f;
	push @sets, [ $d, \@f ];
    }

    my @p = @{shift @sets};
    $main_title = $p[0];
    @files = @{$p[1]};
} else {
    if (!@ARGV) {
	@files = glob("*.log");
    } else {
	@files = @ARGV;
    }
}

my $main_dat = "/tmp/plot.load.balance.dat";
my @order = make_dat($main_dat, \@files);

my @more_dats;
my @more_titles;
my $idx = 0;
foreach my $s (@sets) {
    my $name = "/tmp/plot.load.balance.$idx.dat";
    make_dat($name, $s->[1], \@order);
    push @more_dats, $name;
    push @more_titles, $s->[0];
    $idx++;
}

sub make_dat {
    my $name = shift;
    my $files = shift;
    my @files = @$files;
    my $order = shift;
    my @order = $order ? @$order : undef;

    my @dat;
    
#open(DAT, "| sort -n | perl -e 'while (<>) > /tmp/plot.load.balance.dat") || die $!;
    my $orig = 1;
    foreach my $f (@files) {
	my $stat = new Statistics::Descriptive::Full();
	open(F, "<$f") || die "can't open $f: $!";
	while (<F>) {
	    chomp $_;
	    my @f = split(/\t/, $_);
	    my $v = $f[$FIELD];
	    warn "no field $FIELD" if !defined $v;
	    $stat->add_data( $v );

	    if ($LENGTH && $stat->count() >= $LENGTH) {
		last;
	    }
	}
	close(F);
	my $mean = $stat->mean();
	my $stddev = $stat->standard_deviation();
	#print $DAT "$mean\t$stddev\n";
	push @dat, [$orig, $mean, $stddev];
	$orig++;
    }
    open(DAT, ">$name") || die $!;
    if (!$order) { 
	@dat = sort { $a->[1] <=> $b->[1] } @dat;
    } else {
	@dat = sort { $order[$a->[0]] <=> $order[$b->[0]] } @dat;
    }
    my $index = 1;
    foreach my $d (@dat) {
	print DAT "$index\t$d->[1]\t$d->[2]\n";
	$index++;
    }
    close(DAT);

    my @ret;
    for (my $i=0; $i<@dat; $i++) {
	$ret[$dat[$i]->[0]] = $i;
    }
    return @ret;
}

my $gpl = <<EOT;
set terminal postscript color eps 20
set xlabel "Rank"
set ylabel "Avg. Atttribute"
set key left
#set size 0.8,0.8
set border 31 lw 1.4
set grid ytics lw 2
#set autoscale xfix
#set xtics 1
set yrange [0:]
EOT

#if ($KEY) {
#    $gpl .= "set key outside below Left reverse\n";
#}

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

$gpl .= "plot '$main_dat' title '$main_title' with points pt 5 lt 1";
if ($ERRORBARS) {
    $gpl .= ",     '$main_dat' title '' with errorbars lt 1";
}

for (my $i=0; $i<@more_dats; $i++) {
    my $pt = $i+6;
    my $lt = $i+2;
    $gpl .= ", '$more_dats[$i]' title '$more_titles[$i]' with points pt $pt lt $lt";
    if ($ERRORBARS) {
	$gpl .= ",     '$more_dats[$i]' title '' with errorbars pt $pt lt $lt";
    }
}
$gpl .= "\n";

# $gpl .= "plot ";
# my $index = 0;
# foreach my $f (@files) {
#     my $safe = $f;
#     $safe =~ s|/|_|g;
#     my $tmp = "/tmp/$safe.dat";
#     print STDERR "cat $f $pipe > $tmp\n";
#     system("cat $f $pipe > $tmp") && die "stoopid";

#     $gpl .= ", " if $index++ != 0;
#     $gpl .= "'$tmp' w lines lw 2";
# }
# $gpl .= "\n";

$gpl .= "  ";
open G, "| gnuplot > /tmp/ts.plot.ps";
print G $gpl;
close G;

system("gv /tmp/ts.plot.ps");
