#!/usr/bin/perl
use strict;
use Getopt::Std;
use Statistics::Descriptive;
use vars qw($opt_f);

getopts("f");

my $DIR = shift || ".";
print sprintf ("        NODE\tMAX\tMEAN\n");

foreach my $log (glob ("$DIR/OutputLog.*")) {
    next if $log =~ /bootstrap/;
    my $node = $log;
    $node =~ s/OutputLog.//;
    $node =~ s/\.out//;
    $node =~ s/$DIR\///;

    my $stat = new Statistics::Descriptive::Full ();
    open F, "$log" or die "$!";
    while (<F>) { 
	chomp;
	next if (!/(\d+) pkts received; (\d+) pkts dropped/);
        my $s = $opt_f ? ($1>0?$2/$1:0) : $2;
	$stat->add_data ($s);
    }

    print sprintf("$node\t" . ($opt_f?"%.3f":"%d") . "\t%.3f\n", $stat->max (), 
	    $stat->mean ());
    close F;
}
