#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../../Merc/util/types.h"

void ParseFile(FILE *fp)
{
    byte dir;
    byte proto;
    int type;
    uint32 size;
    uint32 nonce;
    uint16 hopcount;       // ashwin
    double t;

    while (!feof(fp))
    {
	fread((void *) &nonce, sizeof(uint32), 1, fp);
	fread((void *) &t, sizeof(double), 1, fp);
	fread((void *) &dir, sizeof(byte), 1, fp);
	fread((void *) &proto, sizeof(byte), 1, fp);
	fread((void *) &type, sizeof(int), 1, fp);
	fread((void *) &size, sizeof(uint32), 1, fp);
	fread((void *) &hopcount, sizeof(uint16), 1, fp);
	fprintf(stdout, "%08X\t%13.3f\t%d\t%d\t%d\t%d\t%d\n",
		nonce, t, (int)dir, (int)proto, (int)type, (int)size, (int) hopcount);
    }
		
}

int main(int argc, char **argv)
{
    int i;
    if (argc < 2) {
	fprintf(stderr, "usage: ParseMessageLog <log_files>\n");
	exit(1);
    }

    for (i = 1; i < argc; i++) 
    {
	FILE *fp = fopen(argv[i], "r");
	if (!fp) {
	    fprintf(stderr, "can't open file %s\n", argv[i]);
	    exit(1);
	}

	ParseFile(fp);
	fclose(fp);
    }
    return 0;    
}
