#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../../Merc/util/types.h"

void ParseFile(FILE *fp)
{
    byte   type;
    uint16 hops;
    uint32 nonce;
    uint32 alias;
    double t;

    while (!feof(fp))
    {
	fread((void *) &t, sizeof(double), 1, fp);
	fread((void *) &type, sizeof(byte), 1, fp);
	fread((void *) &hops, sizeof(uint16), 1, fp);
	fread((void *) &nonce, sizeof(uint32), 1, fp);
	fread((void *) &alias, sizeof(uint32), 1, fp);

	if (alias == 0) {
	    fprintf(stdout, "%13.3f\t%d\t%d\t%08X\n", 
		    t,
		    (int)type, (int)hops, nonce);
	} else {
	    fprintf(stdout, "%13.3f\t%d\t%d\t%08X\t%08X\n",
		    t, 
		    (int)type, (int)hops, nonce, alias);
	}
    }
}

int main(int argc, char **argv)
{
    int i;
    if (argc < 2) {
	fprintf(stderr, "usage: ParseDiscoveryLatLog <log_files>\n");
	exit(1);
    }

    for (i = 1; i < argc; i++) 
    {
	FILE *fp = fopen(argv[i], "r");
	if (!fp) {
	    fprintf(stderr, "can't open file %s\n", argv[i]);
	    exit(1);
	}

	ParseFile(fp);
	fclose(fp);
    }
    return 0;    
}
