#!/usr/bin/perl
#
# -s num   - skip the first x seconds of the trace
# -l num   - the length of time to aggregate over (ignore remainder)
# -e epoch - size of each aggregation epoch (sec -- floating point)

use strict;
use Getopt::Std;
use vars qw($opt_s $opt_l $opt_e ); 

our $PROTO_OVERHEAD_BYTES = 28;

getopts("s:l:e:d:t:moaM:b");

our $SKIPTIME = defined $opt_s ? $opt_s : 0;
our $LENGTH   = defined $opt_l ? $opt_l : undef;
our $EPOCH    = defined $opt_e ? $opt_e : 1;

###############################################################################

our @LOGS = OpenFiles(@ARGV);
our $start = min( GetHeadTimes(@LOGS) ) + $SKIPTIME;
our $end = $start+$LENGTH;
ScrollUntilTime($start, @LOGS);

ProcessInput(@LOGS);

###############################################################################

our %Objects;

sub ProcessInput(@)
{
    my @files = @_;

    my @buckets;

    my($start, $end);

    my $line;

    foreach my $f (@files) {

	while ($line = GetNext($f)) {
	    chomp $line;
	    if ($line =~ /^(\d+\.\d+)\t([^\t]+)\t([^\t]+)\t([^\t]+)/) {
	    
		last if $time > $end;

		# XXX TODO
	}
    }
}

###############################################################################

sub OpenFiles {
    my @logs = @_;
    my @ret;

    foreach my $file (@logs) {
	my $fh = new IO::File("<$file");
	die "can't open $file" if !$fh;
	push @ret, [ [], $fh, 0 ];
    }

    return @ret;
}

sub GetResid($) { 
    my $ret = shift @{$_[0]->[0]}; 
    $_[0]->[2] = 0 if @{$_[0]->[0]} == 0;
    return $ret;
}

sub AddResid($@) { 
    my $log = shift;
    push @{$log->[0]}, @_; 
    $log->[2] = 1;
}

sub GetFile($) { return $_[0]->[1] }

sub GetNext($) {
    my $log = shift;
    if ($log->[2]) {
	#print STDERR "here\n";
	return GetResid($log);
    } else {
	#print STDERR "there\n";
	my $f = $log->[1];
	return <$f>;
    }
}

sub GetHeadTimes {
    my @logs = @_;
    my @ret;

    foreach my $log (@logs) {
	my $line = GetNext($log);
	die "no lines in log!" if !$line;
	chomp $line;
	$line =~ /^(\d+\.\d+)/;
	push @ret, $1;
	AddResid($log, $line);
    }

    return @ret;
}

sub ScrollUntilTime {
    my $time = shift;
    my @logs = @_;
    my @ret;

    foreach my $log (@logs) {
	my $line;

	print STDERR ".";

	while ($line = GetNext($log)) {
	    chomp $line;
	    $line =~ /^(\d+\.\d+)/;
	    my $t = $1;
	    #push @ret, $line;
	    if ($t < $time) {
		next;
	    } else {
		last;
	    }
	}
	AddResid($log, $line) if $line;
    }

    print STDERR "done!";
}

sub min {
    my @vals = @_;
    my $min = shift @vals;

    foreach my $v (@vals) {
	if ($min > $v) {
	    $min = $v;
	}
    }

    return $min;
}
