#!/usr/bin/perl
# 
# report statistics about interests -- right now, reports stats about the origins
# where bots are. bucketizes the positions
#
#  -b bucket-length       (divide the dimension(s) into equal buckets of this size)
#  -d dimension           (the dimension to bucketize)
#

use strict;
use Getopt::Std;
use vars qw($opt_b $opt_d);

our @attrs;
our $attr_index = -1;

getopts("b:d:");
our $BUCKET_LEN = defined $opt_b ? $opt_b : 512;
our $DIM = defined $opt_d ? $opt_d : "x";

######################################################################
ReadSchemaFile("$TOPDIR/build/schema_quake.cfg");
my @stats = ProcessInput(@ARGV);

for (my $i = 0; $i < scalar @stats; $i++)
{
    printf(" %8d %8d %8d\n", 
	    int($i * $BUCKET_LEN + $attrs[$attr_index]->{'min'}),
	    int(($i + 1) * $BUCKET_LEN + $attrs[$attr_index]->{'min'}),
	    $stats[$i]
	  );
}
#####################################################################

sub ProcessInput(@)
{
    my @files = @_;
    my @stats = ();

    my $tot_bkts = int(($attrs[$attr_index]->{'max'} - $attrs[$attr_index]->{'min'})/$BUCKET_LEN);
    for (my $i = 0; $i < $tot_bkts; $i++)
    {
	$stats[$i] = 0;
    }
    
    foreach my $f (@files) {
	open(F, "<$f") || die "can't open $f";

	while (<F>) {
	    chomp $_;
	    my ($frameno, $guid, $type, $orig, $min, $max) = split(/\t/, $_);

	    my @coords = split(/,/, $orig);
	    $stats[ int( ($coords[$attr_index] - $attrs[$attr_index]->{'min'}) / $BUCKET_LEN) ]++;
	}
    }

    return @stats;
}

sub ReadSchemaFile($) {
    my $file = shift;
    open F, $file or die "could not open file $file for reading...\n";
    my $line;
    my $index = 0;
    
    while (defined ($line = <F>)) 
    {
	next if ($line =~ /^#/);
	next if ($line =~ /^\s*$/);
	my @arr = split(/\s+/, $line);
	
	$attrs[$index]->{'name'} = $arr[0];
	$attrs[$index]->{'min'} = $arr[2];
	$attrs[$index]->{'max'} = $arr[3];

	$index++;
    }
    close F;

    for (my $i = 0; $i < scalar @attrs; $i++)
    {
	if ($attrs[$i]->{'name'} eq $DIM)
	{
	    $attr_index = $i;
	    last;
	}
    }

    if ($attr_index == -1) 
    {
	die "Could not find the attribute from the schema file!";
    }

}
