#!/usr/bin/perl
#
# Takes in a LoadEstimateAccuracy log and generates a corresponding
# time series of when the node is above, between, and below the water
# marks. (1 = high, 0 = between, -1 = low)
#

use strict;

while (<>) {
    chomp $_;
    if ($_ =~ /^([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)\t([^\t]+)/) {
	my ($time, $load, $target, $window, $sysavg, $sysstddev) =
	    ($1, $2, $3, $4, $5, $6);

	my $lowwater  = max($target - $window/2, 0);
	my $highwater = $target + $window/2;

	my $level;
	if ($load < $lowwater) {
	    $level = -1;
	} elsif ($load > $highwater) {
	    $level = 1;
	} else {
	    $level = 0;
	}

	print "$time\t$level\n";
    } else {
	warn "bad line: $_";
    }
}

sub max {
    my ($a, $b) = @_;
    return $a > $b ? $a : $b;
}
