#!/usr/bin/perl
#

use strict;
use Getopt::Std;
use vars qw($opt_s $opt_l);

getopts("s:l:");

our %stats = ProcessInput(@ARGV);
my ($recv, $sent, $err);

print sprintf("%-20s %15s   %15s   %15s\n",
	      "File", "Recvd Packets", "Recv Errors", "Sent Packets");
foreach my $f (keys %stats) {
    print sprintf("%-20s %15d   %15d   %15d\n", 
		  $f, $stats{$f}->{'PKT_RECV'}, $stats{$f}->{'PKT_ERR'}, $stats{$f}->{'PKT_SENT'});
    $recv += $stats{$f}->{'PKT_RECV'};
    $sent += $stats{$f}->{'PKT_SENT'};
    $err  += $stats{$f}->{'PKT_ERR'};

}

printf("\n%-20s %15d   %15d   %15d\n", "Total", $recv, $err, $sent);

sub ProcessInput(@)
{
    my @files = @_;

    my($l);
    my %stats;

    foreach my $f (@files) {
	open(F, "<$f") || die "can't open $f";

	$l = <F>; # Udp:
	$l = <F>; # 1271 packets received
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_RECV'} = $1;
	
	$l = <F>; # packets to unknown port
	$l = <F>; # packet receive errors
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_ERR'} = $1;
	
	$l = <F>; # packets sent
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_SENT'} = $1;
	
	$l = <F>; # Udp:
	$l = <F>; # 1271 packets received
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_RECV'} = $1 - $stats{$f}->{'PKT_RECV'};
	
	$l = <F>; # packets to unknown port
	$l = <F>; # packet receive errors
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_ERR'} = $1 - $stats{$f}->{'PKT_ERR'};
	
	$l = <F>; # packets sent
	$l =~ m/(\d+)/;
	$stats{$f}->{'PKT_SENT'} = $1 - $stats{$f}->{'PKT_SENT'};
    }

    return %stats;
}
