#!/usr/bin/perl
use strict;
use Options;

my $basedir;
chomp ($basedir = `dirname $0`);
require "$basedir/Common.pl";

use vars qw($NO_AGGREGATE $NORMALIZE_SAMPLES);
my @options = (
    Options::Boolean ('A', 'no-aggregate', 'normal message logs (not aggregate)', \$NO_AGGREGATE),
    Options::Boolean ('n', 'normalize', 'normalize sizes by dividing by #samples', \$NORMALIZE_SAMPLES),
);
@ARGV = ProcessOptions (\@options, \@ARGV, -complain => 1);

our @DIRS = ('IN', 'OUT');

our %MsgTypes = ParseMessageHeader($0);
while (<STDIN>) {

    chomp $_;
    my @fields = split (/\t/, $_);
    if ($NO_AGGREGATE) {
	$fields [2] = $DIRS [$fields [2]];
	$fields [4] = $MsgTypes {$fields [4]};
    }
    else {
	$fields [1] = $DIRS [$fields [1]];
	$fields [2] = $MsgTypes {$fields [2]};
	if ($NORMALIZE_SAMPLES) {
	    $fields [3] = sprintf ("%.1f", $fields [3] / $fields [4]);
	    $fields [4] = 1;
	}
    }
    print join ("\t", @fields), "\n";
}

