#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_g);

getopts("g:");

my $file = $ARGV[0];
my @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());

my @points = split(/\n/, `cat $file | awk '{ print \$13 }'`);
shift @points;

open(TMP, ">/tmp/dat") || die "can't open /tmp/dat";
map { print TMP "$_\n" } @points;
close TMP;

system("cdf.pl -d /tmp/dat > /tmp/cdf");

my $gpl = <<EOT;
set terminal postscript eps 20
set xlabel "Discovery time (sec)"
set ylabel "Frac. times < x"
set key bottom right
set size 0.8,0.8
set border 31 lw 1.4
set yrange [0:1]
set grid ytics lw 2 
EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

$gpl .= <<EOT;

plot \\
    '/tmp/cdf' index 0 title '150 nodes' w lp lw 2.5 ps 1 pt 5 lt 1
EOT

$gpl .= "  ";
open G, "| gnuplot";
print G $gpl;
close G;
