#!/usr/bin/perl
#
# Similar to cut, but do arithmetic on fields

use strict;
use Getopt::Std;
use vars qw($opt_f $opt_d);

getopts("f:d:");

die ("usage: Cut++.pl -f field_spec file") if ! $opt_f;

my $delim = $opt_d || "\t";

sub add { $_[0] + $_[1] }
sub _sub { $_[0] - $_[1] }
sub mul { $_[0] * $_[1] }
sub div { $_[0] / $_[1] }
#sub max { $_[0]>$_[1] ? $_[0] : $_[1] }
#sub min { $_[0]<$_[1] ? $_[0] : $_[1] }
#sub union {
#    return $_[1] if ! $_[0];
#    return $_[0] if ! $_[1];
#
#    foreach my $e (keys %{$_[1]}) {
#	$_[0]->{$e} = 1;
#    }
#    return $_[0];
#}

sub select_oper {
    if ($_[0] eq '+') {
	return \&add;
    } elsif ($_[0] eq '-') {
	return \&_sub;
    } elsif ($_[0] eq '*') {
	return \&mul;
    } elsif ($_[0] eq '/') {
	return \&div;
    } elsif (!$_[0]) {
	return undef;
    } else {
	die "bad oper $_[0]";
    }
}

my $depth = 0;

sub build {
    my $tokens = shift @_;
    my ($op) = (shift @$tokens);

    if ($op eq '(') {
	$depth++;
	$op = build($tokens);
    }

    die "bad field_spec" if !defined $op;
    my $oper = select_oper(shift @$tokens);
    if ($oper) {
	
	if ($oper eq ')') {
	    die "mismatched parenthesis" if $depth < 1;
	    $depth--;
	    return $op;
	} else {
	    return [ $oper, $op, build($tokens) ];
	}
    } else {
	return $op;
    }
}

my @spec = split(/,/, $opt_f);
foreach my $s (@spec) {
    # xxx: parens don't work yet -- they aren't split into tokens...
    my @tokens = split(/\b/, $s);
    $s = build(\@tokens);
}

sub compute {
    my $s = shift;
    if (ref($s) ne 'ARRAY') {
	return $_[$s-1];
    } else {
	return &{$s->[0]}(compute($s->[1], @_),
			  compute($s->[2], @_));
    }
}

while(<>) {
    chomp;
    my @fields = split(/$delim/);
    for (my $i=0; $i<@spec; $i++) {
	print "$delim" if $i != 0;
	my $ret = compute($spec[$i], @fields);
	print "$ret";
    }
    print "\n";
}
