#!/usr/bin/perl
#
# -g gnuplot_options (separated by commas)
# -a count absolute # missing objects rather than frac.

use strict;
use Getopt::Std;
use vars qw($opt_g $opt_a);

getopts("g:a");

my $ABSOLUTE = $opt_a;
my @GPLOT_OPTS = (defined $opt_g ? split(/,/, $opt_g) : ());
my $fudge0 = $ARGV[0];
my $fudge1 = $ARGV[1];
my $fudge4 = $ARGV[2];

my @fudge0pts = getPoints($fudge0);
my @fudge1pts = getPoints($fudge1);
my @fudge4pts = getPoints($fudge4);

sub getPoints {
    my $dir = shift;
    my @points;

    my $fields;
    if (!$ABSOLUTE) {
	$fields = "4,5";
    } else {
	$fields = "2,4";
    }

    open(O, "cut -f$fields $dir/* |") || die;
    while (<O>) {
	chomp $_;
	my ($needed, $point);

	if (!$ABSOLUTE) {
	    ($needed, $point) = split(/\t/, $_);
	} else {
	    ($point, $needed) = split(/\t/, $_);
	}
	push @points, $point if $needed;
    }
    close(O);
    return @points;
}

open(TMP, ">/tmp/dat1") || die "can't open /tmp/dat1";
map { print TMP "$_\n" } @fudge0pts;
close TMP;

system("cdf.pl -d /tmp/dat1 > /tmp/cdf1");

open(TMP, ">/tmp/dat2") || die "can't open /tmp/dat2";
map { print TMP "$_\n" } @fudge1pts;
close TMP;

system("cdf.pl -d /tmp/dat2 > /tmp/cdf2");

open(TMP, ">/tmp/dat3") || die "can't open /tmp/dat3";
map { print TMP "$_\n" } @fudge4pts;
close TMP;

system("cdf.pl -d /tmp/dat3 > /tmp/cdf3");


my $xlabel = $ABSOLUTE ? "Num. mobile objects missing" : "Frac. mobile objects missing";

my $gpl = <<EOT;
set terminal postscript eps 20
set xlabel "$xlabel"
set ylabel "Frac. times missing < x objects"
set key bottom right
set size 0.8,0.8
set border 31 lw 1.4
set yrange [0.8:1]
set grid ytics lw 2 
EOT

if (@GPLOT_OPTS) {
    foreach my $opt (@GPLOT_OPTS) {
	$gpl .= "$opt\n";
    }
}

$gpl .= <<EOT;

plot \\
    '/tmp/cdf3' index 0 title '< 400ms error' w lp lw 2.5 ps 1 pt 6 lt 3, \\
    '/tmp/cdf2' index 0 title '< 100ms error' w lp lw 2.5 ps 1 pt 4 lt 2, \\
    '/tmp/cdf1' index 0 title 'no error' w lp lw 2.5 ps 1 pt 5 lt 1 \\
EOT

$gpl .= "  ";
open G, "| gnuplot";
print G $gpl;
close G;
