no strict;

# this is a really hacky and weirdo wrapper
# around gnuplot. someday it should be 
# cleaned up. at this point, it serves me exactly
# two purposes:
#  1. spares me from remembering gnuplot syntax ordering
#  2. spares me from scripting "plot/replot" everytime i have multiple curves
#
# $Id: CommonPlot.pl 1767 2005-03-18 22:22:59Z ashu $
#
# - Ashwin [03/18/2005]

local $graph;
local $replot;
local $useold;
local $graphtype;

sub begin_plot {
    my %params = @_;

    $graph = qq(
set style line 1 lw 1.4 ps 0.9
set xlabel "$params{xlabel}"
set ylabel "$params{ylabel}"
	    );

    $graphtype = $params{graphtype};
    if ($params{graphtype} eq 'eps') { 
        $graph .= "set terminal postscript eps\n";
    }
    elsif ($params{graphtype} eq 'pdf') { 
        $graph .= "set terminal pdf fsize 7\n";
    }
    else {
	$graph .= "set terminal postscript\n";
    }

    if (exists $params{xrange}) {
	$graph .= qq(set xrange $params{xrange}\n);
    }
    if (exists $params{yrange}) {
	$graph .= qq(set yrange $params{yrange}\n);
    }
    if (exists $params{title}) {
	$graph .= qq(set title "$params{title}"\n);
    }

    if (exists $params{dothis}) {
	$graph .= qq($params{dothis}\n);
    }
    if (exists $params{useold}) {
	$useold = 1;
    } else {
	$useold = 0;
    }
    $replot = 0;
}

sub plot {
    my %params = @_;
    my $data = $params{data};
    return unless (defined $data || $useold == 1);

    if (!$replot) {
	$graph .= "plot ";
    } 
    else {
	$graph .= ", ";
    }
    $replot++;

    my $prog_name = $0;
    $prog_name =~ s/\.pl//;
    my $tmp_file = "__${prog_name}_data_$replot";
    $data = $tmp_file if ($useold == 1);
    if (ref($data) eq "ARRAY") {
	$graph .= "'$tmp_file' ";
    }
    else {
	$graph .= "'$data' ";
    }
    if (exists $params{'index'}) {
	$graph .= "index $params{index} ";
    }
    if (exists $params{using}) { 
	$graph .= "using $params{using} ";
    }
    if (exists $params{title}) {
	if ($params{title} eq "notitle") {
	    $graph .= qq(notitle );
	} else {
	    $graph .= qq(title "$params{title}" );
	}
    }
    if (exists $params{with}) {
	$graph .= qq(with $params{with} );
    }
    if (ref($data) eq "ARRAY") {
	my $sub = $data->[0];
	my @args = ();
	for (my $i = 1; $i < scalar @$data; $i++) {
	    push @args, $data->[$i];
	}
	my $to_plot = &$sub(\@args);

         # make a unique filename for this plot
	open F, ">$tmp_file" or die "can't open file to write...";
	print F $to_plot;
	close F;
    }
}

sub commit_plot {
    my $ofile = shift;

    if ($graphtype eq 'eps') {  $ofile = "$ofile.eps"; }
    elsif ($graphtype eq 'pdf') { $ofile = "$ofile.pdf"; }
    else {  $ofile = "$ofile.ps"; }
    
    open F, " | gnuplot > $ofile";
    print F $graph;
    close F;
}

1;
