=start
package Common;
require Exporter;

our @ISA = ("Exporter");
our @EXPORT = qw($TOPDIR %MsgTypes Initialize ParseMessageHeader IsMercMsg IsAppMsg IsRoutingMsg);
=cut

our $TOPDIR = $ENV{HOME} . "/Colyseus";
our %MsgTypes = ();
our $MsgMercSentinel;
our %RouteMsgTypes = ();

our $inited = 0;

sub GetKeyForType ($)
{
    my $type = shift;
    foreach my $key (keys %MsgTypes) {
	if ($MsgTypes{$key} eq $type) {
	    return $key;
	}
    }
    return undef;
}
    
sub Initialize($) {
    return if ($inited);
    
    my $progname = shift;
    $basedir = `dirname $progname`;
    chomp $basedir;
    $TOPDIR = "$basedir/../";

    $inited = 1;
}

###############################################################################
sub ParseMessageHeader($) 
{
    Initialize ($_[0]);
    
    my $file = "$TOPDIR/scripts/MsgTypes.cfg";
    open(HEADER, $file) or die "can't open $file";
    
    while (<HEADER>) {
	chomp $_;
	if ($_ =~ /(MSG_.*) (\d+)/) {
	    my $name = $1;
	    my $index = $2;
	    
	    $MsgTypes{$index} = $name;

	    if ($name eq 'MSG_MERCURY_SENTINEL') {
		$MsgMercSentinel = $index;
	    }
	}
    }
    
    close(HEADER);
    die if !defined $MsgMercSentinel;

    my @routemsgs = qw(MSG_PUB MSG_LINEAR_PUB MSG_ACK MSG_SUB MSG_LINEAR_SUB
	    MSG_PUB_LINEAR MSG_SUB_LINEAR MSG_SUB_NOTROUTING
	    MSG_RANGE_PUB MSG_RANGE_PUB_LINEAR MSG_RANGE_PUB_NOTROUTING
	    );
    foreach my $rm (@routemsgs) {
	foreach my $key (keys %MsgTypes) { 
	    if ($MsgTypes{$key} eq $rm) {
		$RouteMsgTypes{$key} = 1;
		last;
	    }
	}
    }
    return %MsgTypes;
}

sub psystem ($) {
    my $cmd = shift;
    print $cmd, "\n";
    return system ($cmd);
}

sub IsMercMsg($)
{
    my $t = shift;

    return $t < $MsgMercSentinel;
}

sub IsAppMsg($)
{
    my $t = shift;

    return $t > $MsgMercSentinel;
}

sub IsRoutingMsg($)
{
    my $t = shift;
    return exists $RouteMsgTypes{$t};
}

1;
