#!/usr/bin/perl
#
# Merge all the split logs on this directory into single log files (in order)
#
# usage: CombineLogs.pl [-o output_dir]
#

use strict;
use Getopt::Std;
use vars qw($opt_o);

require "Common.pl";

getopts("o:");

our $DIR = $opt_o || ".";

if (defined $ARGV[0]) {
    chdir($ARGV[0]) || die "can't chdir to $ARGV[0]";
}

my @files = sort { $a cmp $b }  glob("*.log*");
my $curr;
my @curr;
my $last;

my $success = 1;

foreach my $file (@files) {
    if ($curr eq '' || $file !~ /^$curr/) {
	if ($last || @curr > 0) {
	    my $cmd = "cat " . join(" ", @curr, $last) . 
		" > $DIR/$curr.merged";
	    print STDERR "$cmd\n";
	    $success &&= !system("$cmd");
	}
	@curr = ();
	$last = '';
	$file =~ /^(.+\.log)/;
	die "WTF: $file" if !$1;
	$curr = $1;

	if ($file eq $curr) {
	    die "WTF: $file last=$last" if $last;
	    $last = $file;
	} else {
	    push @curr, $file;
	}
    } else {
	if ($file eq $curr) {
	    die "WTF: $file last=$last" if $last;
	    $last = $file;
	} else {
	    push @curr, $file;
	}
    }
}
if ($last || @curr) {
    my $cmd = "cat " . join(" ", @curr, $last) . 
	" > $DIR/$curr.merged";
    print STDERR "$cmd\n";
    $success &&= !system("$cmd");
}

if ($success) {
    print STDERR " ---------- Successfully Merged Logs ---------- \n";
    unlink @files;
} else {
    print STDERR " ********** FAILED to Merge Logs ********** \n";
}
