#!/usr/bin/perl

use strict;

my %types = ( 'p' => [0,0],
	      'm' => [0,0],
	      'all' => [0,0] );

my $i=0;
while (<>) {
    print STDERR "." if $i++ % 1000000 == 0;
    chomp;
    if (/[^ \t]+\s+(\w)\s+(0|1)/) {
	my ($t, $fizzed) = ($1, $2);
	if (!$types{$t}) {
	    warn "unknown type: $t";
	} else {
	    $types{$t}->[1]++;
	    $types{$t}->[0]++ if $fizzed;
	}
	$types{all}->[1]++;
	$types{all}->[0]++ if $fizzed;
    } else {
	warn "bad line: $_";
    }
}
print STDERR "\n";

foreach my $k (keys %types) {
    my $fizzed = $types{$k}->[0];
    my $total = $types{$k}->[1];
    my $frac  = $fizzed/$total;
    print "$k\t$frac\t$fizzed\t$total\n";
}
