#!/usr/bin/perl
#
# -s num - skip the first x seconds of each file
# -l num - the length of time to aggregate over 

my @proc_bw = ();

use strict;
use Getopt::Std;
use vars qw($opt_s $opt_l);
use Statistics::Descriptive;

my $basedir;
chomp ($basedir = `dirname $0`);
require "$basedir/Common.pl";

getopts("s:l:");

our $SKIPTIME = defined $opt_s ? $opt_s : undef;
our $LENGTH   = defined $opt_l ? $opt_l : undef;
our %stats = ();

our %MsgTypes = ParseMessageHeader($0);
foreach my $stat ("MERC", "TOTAL") {
    foreach my $dir ("IN", "OUT") {
	foreach my $unit ("kbps", "pps", "kbps_w_ohead") {
	    $stats{$stat}->{$dir}->{$unit} = new Statistics::Descriptive::Full();
	}
    }
}

## fill in the %stats hash with all stats from all nodes
ProcessExperiment(@ARGV);  

print sprintf("%-18s %14s %14s %14s %14s\n", "Type", "Mean", "Median", "75th perc", "90th perc");
print "="x80, "\n";
foreach my $unit ("kbps", "pps", "kbps_w_ohead") {
    print  "unit ---> ", uc($unit), "\n", "-"x80, "\n";
    foreach my $dir ("IN", "OUT") {
	foreach my $stat ("MERC", "TOTAL") {
	    my $s = $stats{$stat}->{$dir}->{$unit};
	    my @data = $s->get_data();
	    @data = sort { $a <=> $b } @data;
	    my $nitems = $s->count();
	    
	    print sprintf("%-18s %14.3f %14.3f %14.3f %14.3f\n", 
		    "$dir:$stat", 
		    $s->mean(), 
		    $s->median(), 
		    $data[ int(0.75 * $nitems) ],
		    $data[ int(0.9 * $nitems) ]);
	}
    }
}

sub ProcessExperiment(@) {
    my @files = @_;
    my $nodes = scalar @files;
    my $extra_args = "";
    $extra_args .= " -s $SKIPTIME " if defined $SKIPTIME;
    $extra_args .= " -l $LENGTH" if defined $LENGTH;
    
    foreach my $f (@files)
    {
	print STDERR "processing file $f...\n";
	chomp (@proc_bw = `zcat $f | $basedir/ParseMessageLog /dev/stdin | perl $basedir/MessageLogAggregate.pl $extra_args /dev/stdin`);
	shift @proc_bw;        # first header line;

	my %merc = ();

	foreach my $s (@proc_bw) {
	    my ($name, @numbers);
	    ($name, @numbers) = split(/\s+/, $s);
	    my $index;

	    $index = 0;

	    next if ($name =~ /TCP/ or $name =~ /UDP/);
	    foreach my $unit ("kbps", "pps", "kbps_w_ohead") {
		if ($name eq 'IN') {
		    $stats{"TOTAL"}->{"IN"}->{$unit}->add_data($numbers[$index] + 0.0);
		}
		elsif ($name eq "OUT") {
		    $stats{"TOTAL"}->{"OUT"}->{$unit}->add_data($numbers[$index] + 0.0);
		}
		elsif ($name !~ /MSG_APP/) {
		    if ($name =~ /IN:/) {
			$merc{"IN"}->{$unit} += $numbers[$index];
		    }
		    else {
			$merc{"OUT"}->{$unit} += $numbers[$index];
		    }
		}

		$index++;
	    }
	}
	
	foreach my $unit ("kbps", "pps", "kbps_w_ohead") {
	    foreach my $dir ("IN", "OUT") {
		$stats{"MERC"}->{$dir}->{$unit}->add_data($merc{$dir}->{$unit});
	    }
	}
    }
}

