#!/usr/bin/perl
use strict;
use Travertine;
use Options;

##################################################################
use vars qw($BOTS $SERVERS $KILL);
my @options = (
    Options::String ("b", "bots", "number of bots per server", \$BOTS, "4"),
    Options::String ("n", "servers", "number of servers (<= defined in RunDemoLive.pl)", \$SERVERS, "2"),
    Options::Boolean ("k", "kill", "kill the experiment", \$KILL),
);
@ARGV = ProcessOptions (\@options, \@ARGV, -complain => 1);
my $etc = join (" ", @ARGV);

my $cmd = "perl demo/RunDemoLive.pl";
my $kill_arg = defined $KILL ? "-k" : "";
my $opts = "$kill_arg Quake3Conf.pl $SERVERS --timelimit 5184000000 --nbots $BOTS --map q3floor " .
" --nolat --logenableonly QuakeStatsLog --bpatterns XXGM_ $etc ";

ppsystem ("$cmd $opts");
