#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/Merc/run";
use Travertine;

my $out    = "/usr2/jeffpang/planetlab/results/bwidth";
my $script = "$ENV{HOME}/Merc/scripts/AggMsgLogTimeSeries.pl";
my $max    = "$ENV{HOME}/Merc/scripts/MaxStartTime.pl";
my $filter = "$ENV{HOME}/Merc/scripts/TimeFilter.pl";

our $SKIPTIME = 0;
our $LENGTH   = 31536000;

my @logs = glob("AggregateMessageLog.*");
my %hosts;

foreach my $l (@logs) {
    if ($l =~ /AggregateMessageLog\.(\d+\.\d+\.\d+\.\d+)\:\d+/) {
	if (!defined $hosts{$1}) {
	    $hosts{$1} = [];
	}
	push @{$hosts{$1}}, $l;
    } else {
	tdie "bad log name: $l";
    }    
}

psystem("mkdir -p $out") and tdie "couldn't mkdir $out";

foreach my $k (keys %hosts) {
    my @files = @{$hosts{$k}};
    psystem("$script -s $SKIPTIME -l $LENGTH " . join(" ", @files) . 
	    " > $out/$k.log");
}

my $start = `$max -M $out/*.log`;
chomp $start;

foreach my $k (keys %hosts) {
    if (`wc -l $out/$k.log` =~ /^\s*0\s+/) {
	unlink "$out/$k.log";
	next;
    }
    psystem("$filter -r -S $start -s $SKIPTIME -l $LENGTH $out/$k.log > $out/$k.ts");
    unlink "$out/$k.log";
}
