#!/usr/bin/perl

use strict;
use lib "./planetlab";
use Travertine;
use PlanetLabConf;

our $MAX_PARALLEL_INSTALLS = 10;

our $func = sub {
  my $TOPDIR = shift;
  my $hostname = `hostname`;

  ## configuration
  my $COTOP_URL = "http://gs3078.sp.cs.cmu.edu/pkgs/cotop-0.9b.tar.bz2";
  my $BITTORRENT_URL = "http://gs3078.sp.cs.cmu.edu/pkgs/bittorrent-3.4.2-1.1.fc1.rf.noarch.rpm";
  my @YUM_RPMS  = ( ); #( 'gdb', 'screen' );

  ## kill off old junk
  psystem("sudo killall -9 wget >/dev/null 2>&1");
  psystem("sudo killall -9 rpm  >/dev/null 2>&1");
  psystem("sudo killall -9 curl >/dev/null 2>&1");
  psystem("sudo killall -9 tar  >/dev/null 2>&1");
  
  ## create directories
  psystem("mkdir -p bin") && tdie "$hostname: can't create bin/";
  psystem("mkdir -p downloads") && tdie "$hostname: can't create downloads/";
  
  chdir "downloads";
  
  ## install cotop
  my($cotop_file) = ($COTOP_URL =~ /([^\/]+)$/);
  my($cotop_dir)  = ($cotop_file =~ /^(.+)\.tar\.bz2$/);
  if (! -e $cotop_file) {
      psystem("rm -rf cotop-*");
      psystem("wget -q $COTOP_URL 1>&2") && 
	  tdie "$hostname: can't wget $COTOP_URL";
      psystem("tar xjf $cotop_file") &&
	  tdie "$hostname: can't untar $cotop_file";
      
      chdir "$cotop_dir" or 
	  tdie "failed to change to cotop directory $cotop_dir";
      psystem("./install") &&
	  tdie "failed to install cotop";
      chdir "..";
  }

  ## install bittorrent rpm
  my($bt_file) = ($BITTORRENT_URL =~ /([^\/]+)$/);
  my($bt_vers) = ($bt_file =~ /^(bittorrent-.*)\.[\w_\-]+\.rpm$/);
  if (`rpm -q bittorrent` !~ /$bt_vers/) {
      psystem("rm -rf bittorrent-*");
      psystem("wget -q $BITTORRENT_URL 1>&2") && 
	  tdie "$hostname: can't wget $BITTORRENT_URL";
      psystem("sudo rpm -e bittorrent >/dev/null 2>&1");
      psystem("sudo rpm -U --nodeps $bt_file") &&
	  tdie "$hostname: can't rpm install $bt_file";
      # stupid plab has python 2.3
      psystem("sudo ln -s /usr/lib/python2.2/site-packages/BitTorrent /usr/lib/python2.3/site-packages/BitTorrent") && tdie "can't create link";
  }

  ## run yum to install base rpms
  if (@YUM_RPMS) {
      psystem("sudo yum -y install " . join(" ", @YUM_RPMS)); # &&
      #tdie "yum install failed to install: " . join(" ", @YUM_RPMS);
      # yum errors when it is already installed...
  }

};

my @hosts = GetPlanetLabHosts();

ParallelExec3($MAX_PARALLEL_INSTALLS, sub {
    my $login = shift;
    my ($user, $mach) = split(/\@/, $login);
    tinfo "## installing on $mach...";
    rsystem($user, $mach, $func, $TOPDIR);
}, map { "$USERNAME\@$_" } @hosts);

tinfo "## done";
