#!/usr/bin/perl
#
# Usage: ./planetlab/PlanetLabInstall.pl [{BT}Install.pl options] [num_nodes]
#
# Set the environmental variable BITTORRENT to use BTInstall.pl.
#

use strict;
use lib "./planetlab";
use Travertine;
use PlanetLabConf;
use Getopt::Std;
use vars qw($opt_k $opt_S $opt_P);

getopts("kPS");

our $MAX_PARALLEL_INSTALLS = 10;

my $app_conf = shift @ARGV;
my $num_nodes;
if ( @ARGV > 0 && 
     (@ARGV == 1 || $ARGV[$#ARGV-1] !~ /^-/) 
     && $ARGV[$#ARGV] =~ /^\d+/ ) {
    $num_nodes = pop @ARGV;
}

my $other_args = join " " , @ARGV;

my @hosts = GetPlanetLabHosts();
unshift @hosts, $BOOTSTRAP;

if ($num_nodes) {
    @hosts = @hosts[0..$num_nodes-1];
}
my $args = join(" ", map { "$USERNAME\@$_" } @hosts);

my $prog = "./Install.pl";
if ($ENV{BITTORRENT}) {
    $prog = "./BTInstall.pl";
}

if ($opt_k) {
    $prog .= " -k";
}
if ($opt_S) {
    $prog .= " -S";
}
if ($opt_P) {
    $prog .= " -P";
}

psystem("$prog $app_conf -l $LOCAL_TOPDIR -t $TOPDIR $other_args $args");

tinfo "## done";

###############################################################################

## this doesn't work since planetlab's ssh-agent forwarding is broken :P
sub RecInstall
{
    our $PARALLEL_TODO = 2;

    my ($src, @todo) = @_;

    my @dest;
    my @rest;

    for (my $i=0; $i<$PARALLEL_TODO; $i++) {
	push @dest, shift @todo if @todo > 0;  
    }
    my $nrec = scalar @dest + 1;

    for (my $i=0; $i<@todo; $i++) {
	for (my $r = 0; $r < $nrec; $r++) {
	    if ($i % $nrec == $r) {
		$rest[$r] = [] if !$rest[$r];
		push @{$rest[$r]}, $todo[$i];
		last;
	    }
	}
    }

    tinfo "installing $src => (@dest)";
    # have him fanout to the @dest
    my ($out, $err, $ret) = Travertine::rsystem($USERNAME, $src, sub {
	my ($topdir, $app_conf, $rest) = @_;

	chdir("$topdir/Merc/run") || twarn "can't chdir $topdir/Merc/run";
	psystem("tar xzf lib-*.tar.gz");
	$ENV{PERL5LIB} .= ":lib";

	if ( psystem("./Install.pl $app_conf -Z -r -t '$topdir' -l '$topdir' $rest") ) {
	    twarn "failed to install (is something missing from the install list?)";
	    return -1;
	}

	return 0;
    }, $TOPDIR, $app_conf, join(" ", @dest));

    if ($ret) {
	twarn "failed $src => (@dest)";
    }

    # recurse on rest
    my @srcs = ($src, @dest); 
    my @args;
    for (my $i=0; $i<@rest; $i++) {
	push @args, [$srcs[$i], @{$rest[$i]}];
    }

    ParallelExec2( \&RecInstall, @args ) if @args > 0;
    return;
}

sub AllInstall
{
    my $node0 = shift @hosts;
    my @rest = @hosts;

    # rsync to one guy
#    psystem("./Install.pl $app_conf -r -l $LOCAL_TOPDIR -t $TOPDIR " .
#	    "$other_args $USERNAME\@$node0");

    # recursively install from this guy to the rest
    RecInstall($node0, @rest);
}
