#
# PlanetLab Configuration
#

package PlanetLabConf;
require Exporter;
use lib "../";
use Travertine;
use strict;

our @ISA    = ("Exporter");
our @EXPORT = qw($USERNAME $TOPDIR $LOCAL_TOPDIR $LOGDIR $MERCDIR
		 $TERMPASS $MERCPORT $HOSTS_FILE GetPlanetLabHosts GetHosts
		 $BOOTSTRAP $PUSHLOGHOST $PUSHLOGDIR);

###############################################################################

# list of planetlab hosts
our $HOSTS_FILE = "$ENV{HOME}/Merc/run/planetlab/hosts.txt";

# username on planetlab nodes
our $USERNAME  = "cmu_games";
# where the top-level "pubsub" directory is on remote hosts
our $TOPDIR = "/home/cmu_games/pubsub";
# where the top-level "pubsub" directory is locally
our $LOCAL_TOPDIR = $ENV{HOME};

# node on which to run bootstrap node
our $BOOTSTRAP = "128.2.220.158"; # xxx

# mercury port (OM port is this+5000, term port is this+10000)
our $MERCPORT = 33157;

# terminal passwd
our $TERMPASS = 'f7Ughi6l';

# remote logdir
our $LOGDIR = "/home/cmu_games/pubsub/Logs";

# local Merc directory
our $MERCDIR   = "$ENV{HOME}/Merc";

# where to push logs to
our $PUSHLOGHOST = "jeffpang\@gs3078.sp.cs.cmu.edu";
our $PUSHLOGDIR  = "/usr2/jeffpang/planetlab";

# planetlab requires version 2
$ENV{TRAVERTINE_SSHVERSION} = '2,1';

###############################################################################

sub GetHosts() {
    return GetPlanetLabHosts();
}

sub GetPlanetLabHosts() {
    my @hosts;
    
    open(H, "<$HOSTS_FILE") || die "can't open $HOSTS_FILE: $!";
    while (<H>) {
	chomp $_;
	next if $_ =~ /^\s*\#/;
	$_ =~ s/^\s+//;
	$_ =~ s/\s*\#.*$//;
	if ($_ =~ /[\w\-_\.]+/) {
	    push @hosts, $_;
	} else {
	    tdie "bad host in $HOSTS_FILE: $_";
	}
    }
    close(H);

    return @hosts;
}
