#!/usr/bin/perl
use strict;
BEGIN {
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    $ENV{TRAVERTINE_PRINTCMDS} = 1;
};

use Travertine;
use Options;
use lib "./local";
use LocalConf;
use vars qw($DUMP_DELTAS $VERBOSITY $BOTCONF $NBOTS $TIMELIMIT $LATENCY $KILL $pushdir $NSERVERS $MAP $MODE $XTERM);

our @optable = (
    Options::Boolean ("d", "deltas", "record deltas for bootstraping encoding", \$DUMP_DELTAS),
    Options::Boolean ("k", "kill", "kill experiment", \$KILL),
    Options::String("V", "verbosity", "[num] debug verbosity level", \$VERBOSITY, -11),
    Options::String("n", "servers", "number of servers", \$NSERVERS, "2"),
    Options::String("t", "timelimit", "time limit in seconds", \$TIMELIMIT, "300"),
    Options::String("m", "map", "map name", \$MAP, "q3dm1"),
    Options::String("B", "botconf", "[num,num...] number of bots for each server", \$BOTCONF, ""),
    Options::String("b", "bots", "number of bots per server", \$NBOTS, "1"),
    Options::String("o", "pushdir", "push log dir", \$pushdir, $PUSHLOGDIR),
    Options::String("E", "mode", "mode (gdb|valgrind)", \$MODE, ""),
    Options::Boolean("x", "xterm", "run xterms", \$XTERM),
    Options::Boolean("l", "latency", "simulate latency", \$LATENCY),
);
@ARGV = ProcessOptions(\@optable, \@ARGV, -complain => 0);

if ($BOTCONF eq '') { 
    $BOTCONF = join (",", map { $NBOTS } (1 .. $NSERVERS));
}

my $opts = "--nmasters $NSERVERS --nbots $BOTCONF ";
if ($LATENCY) { 
    $opts .= " -a pc-cmcl.n8.v4.lat ";
}
else {
    $opts .= " -A ";
}

$opts .= "--verbosity $VERBOSITY --vis-ip 128.2.203.210 ";
$opts .= "--bpatterns XXGM_ --map $MAP ";
if ($DUMP_DELTAS) {
    $opts .= "--deltas --flushimmed ";
}

my $time_msecs = $TIMELIMIT * 1000;
my $local_opts = "-t $TIMELIMIT -v 1 -o ${PUSHLOGHOST}:$pushdir -E '$MODE' ";
if ($MODE eq 'gdb' or $MODE eq 'valgrind') { 
    $local_opts .= " -P ";
}

if ($XTERM) {
    $local_opts .= "-x ";
}
if ($KILL) { 
    $local_opts .= "-k ";
}
$opts .= " -e $time_msecs " . join (" ", @ARGV);
tinfo "opts=$opts";
psystem ("./local/LocalRun.pl $local_opts Quake3Conf.pl $NSERVERS $opts");
