#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k);
use lib "./iris";
use Travertine;
use LocalConf;

getopts("n:t:E:v:b:NCk");

our $APPCONF       = "TestgameConf.pl";

# defaults
our $MODE          = "";
our $KILL          = defined $opt_k;

our $MAX_NODES     = defined $opt_n ? $opt_n : 9;
our $TIME_LIM      = defined $opt_t ? $opt_t : 3*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 10;
our $BOTS          = defined $opt_b ? $opt_b : 10;
our $SLOWDOWN      = 5;

$TIME_LIM = $TIME_LIM * $SLOWDOWN;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;

our $OTHER_ARGS    = " -y '$SLOWDOWN' -B -Z -A "; # to RunV2.pl

$OTHER_ARGS .= " ";

our $OUTPUTOPT = "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "iris.exp.status";

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    $cmd =~ s/&/\\&/g;
    psystem("ssh $PUSHLOGHOST $cmd");
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;

    if ($CHECK_ONLY) {
	$cmd =~ s/LocalRun.pl/LocalRun.pl -C/;
    } elsif ($KILL) {
	$cmd =~ s/LocalRun.pl/LocalRun.pl -k/;
    }

    my $retries = 3;
 
    tinfo "## $name ...";

    my $out;

    while ($out ne 'ok' && $retries > 0) {
        tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < 3;
        $out  = `$cmd`;
	last; # XXX
        chomp $out;
        $retries--;
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################
our @NODES = ( 9 );
our @MAPS  = ( 784 );

if (1) {

    if (1) {
	## vary number of nodes
	special_psystem("mkdir -p '$PUSHLOGDIR/nodes'");
	for (my $i=0; $i<@NODES; $i++) {
	    my $n = $NODES[$i];
	    my $nservers = $n*$VSERVERS;
	    my $waitfor  = $TIME_LIM + 2*$n; # 1 secs/server
	    my $timemsec = $TIME_LIM * 1000;
	    my $map      = "../apps/mapgen/maps/$MAPS[$i]-players";
	    special_psystem("mkdir -p '$PUSHLOGDIR/nodes/$nservers'");
	    exp_psystem("nodes/$nservers",
			"./iris/LocalRun.pl " .
			"-E '$MODE' " .
			"-v '$VSERVERS' " .
			"-I '$IGNORE_NODES' " .
			"-t '$waitfor' " .
			"-o '$OUTPUTOPT/nodes/$nservers' " .
			"$APPCONF $n " .
			"-e $timemsec -m $map -b '$BOTS' $OTHER_ARGS ");
	}
    }
}

###############################################################################

## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
