#!/usr/bin/perl
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k);
use lib "./intel";
use Travertine;
use LocalConf;

getopts("n:t:E:v:b:NCk");

our $APPCONF       = "pingconf.pl";

# defaults
our $MODE          = "";
our $KILL          = defined $opt_k;

our $MAX_NODES     = defined $opt_n ? $opt_n : 10;
our $TIME_LIM      = defined $opt_t ? $opt_t : 30*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 20;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;

our $OTHER_ARGS    = "-M -g --tclat --latency intel.defrag.n10.v20.lat";

$OTHER_ARGS .= " ";

our $OUTPUTOPT = "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "intel.exp.status";

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    $cmd =~ s/&/\\&/g;
    psystem("ssh $PUSHLOGHOST $cmd");
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/Run.pl/Run.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/Run.pl/Run.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if (0) {
	    #if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################
our @NODES = ( 10 );
our @VSERVERS = ( 20 );

if (1) {

    if (1) {
	## vary number of nodes
	my $odir = "ping";
	special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
	for (my $i=0; $i<@NODES; $i++) {
	    my $n = $NODES[$i];
	    my $nservers = $n*$VSERVERS;
	    my $waitfor  = $TIME_LIM + $n; # 1 secs/server
	    my $timemsec = $TIME_LIM * 1000;
	    special_psystem("mkdir -p '$PUSHLOGDIR/$odir/$nservers'");
	    exp_psystem("$odir/$nservers",
			"./intel/LocalRun.pl " .
			"-t '$waitfor' " .
			"-E '$MODE' " .
			"-v '$VSERVERS' " .
			"-o '$OUTPUTOPT/$odir/$nservers' " .
			"$APPCONF $n " .
			"$OTHER_ARGS");
	}
    }
}

###############################################################################

## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
