#!/usr/bin/perl
#
# Usage: ./planetlab/PlanetLabInstall.pl [{BT}Install.pl options] [num_nodes]
#
# Set the environmental variable BITTORRENT to use BTInstall.pl.
#

BEGIN {
# cmu machines are stupid and still use ssh v1
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    #$ENV{TRAVERTINE_PRINTCMDS} = 1;
}

use strict;
use lib "./intel";
use Travertine;
use LocalConf;

our $MAX_PARALLEL_INSTALLS = 5;

my $num_nodes;
if ( @ARGV > 0 && 
     (@ARGV == 1 || $ARGV[$#ARGV-1] !~ /^-/) 
     && $ARGV[$#ARGV] =~ /^\d+/ ) {
    $num_nodes = pop @ARGV;
}

our $app_conf = shift @ARGV;
if (!$app_conf or !-f $app_conf) { 
    Usage("no AppConf or AppConf does not exist");
}

sub Usage {
    my $msg = shift;

    $msg = "exiting" if !defined $msg;
    print STDERR "Usage: LocalInstall.pl AppConf.pl [options to Install.pl]\n";
    tdie "$msg";
}

my $other_args = join " " , @ARGV;

my @hosts = GetHosts();
if ($num_nodes) {
    @hosts = @hosts[0..$num_nodes-1];
}
my $args = join(" ", map { "$USERNAME\@$_" } @hosts);

my $prog = "./Install.pl";
if ($ENV{BITTORRENT}) {
    $prog = "./BTInstall.pl";
}

psystem("$prog $app_conf -p $MAX_PARALLEL_INSTALLS -v -l $LOCAL_TOPDIR -t $TOPDIR $other_args $args");

tinfo "## done";
