#
# Local Configuration
#

package LocalConf;
require Exporter;
use lib "../";
use Travertine;
use strict;

our @ISA    = ("Exporter");
our @EXPORT = qw($USERNAME $TOPDIR $LOCAL_TOPDIR $LOGDIR $MERCDIR
		 $HOSTS_FILE GetHosts
		 $PUSHLOGHOST $PUSHLOGDIR);

###############################################################################

# list of planetlab hosts
our $HOSTS_FILE = "$ENV{HOME}/Colyseus/run/intel/hosts.txt";

# username on planetlab nodes
our $USERNAME  = "jeffpang";
# where the top-level "pubsub" directory is on remote hosts
our $TOPDIR = "/home/jeffpang/ps";
# where the top-level "pubsub" directory is locally
our $LOCAL_TOPDIR = $ENV{HOME};

# remote logdir
our $LOGDIR = "/home/jeffpang/ps/Logs";

# local Merc directory
our $MERCDIR   = "$ENV{HOME}/Merc";

# where to push logs to
our $PUSHLOGHOST = "jeffpang\@10.212.3.70";
our $PUSHLOGDIR  = "/home/jeffpang/logs/defragtest";

# planetlab requires version 2
$ENV{TRAVERTINE_SSHVERSION} = '1,2';

###############################################################################

sub GetHosts() {
    my @hosts;
    
    open(H, "<$HOSTS_FILE") || die "can't open $HOSTS_FILE: $!";
    while (<H>) {
	chomp $_;
	next if $_ =~ /^\s*\#/;
	$_ =~ s/^\s+//;
	$_ =~ s/\s*\#.*$//;
	if ($_ =~ /[\w\-_\.]+/) {
	    push @hosts, $_;
	} else {
	    tdie "bad host in $HOSTS_FILE: $_";
	}
    }
    close(H);

    return @hosts;
}
