#!/usr/bin/perl

BEGIN {
# cmu machines are stupid and still use ssh v1
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    #$ENV{TRAVERTINE_PRINTCMDS} = 1;
}

use strict;
use Getopt::Std;
use vars qw($opt_v $opt_x $opt_g $opt_o $opt_t $opt_I $opt_N $opt_c $opt_P $opt_E $opt_C $opt_d $opt_k $opt_s);
use lib "./intel";
use Travertine;
use LocalConf;

our $MAX_PARALLEL = 10;
getopts("v:t:T:o:xgI:cPE:Cdkls");

our $VSERVERS = $opt_v || 1;
our $SAVEDIR = $opt_o || "$PUSHLOGHOST:$PUSHLOGDIR";
our $DELETE_OLD_LOGS = !defined $opt_d;

if (@ARGV < 1) {
    print STDERR "usage: CollectLogs.pl [options] num_nodes\n";
    print STDERR "        -o login [user\@]host:/dir to push logs to\n";    
    print STDERR "        -d do not delete old logs\n";
    exit 1;
}
our $num_nodes = shift @ARGV;

our @hosts = GetHosts();

if (@hosts < $num_nodes) {
    tdie "not enough hosts in host file! (" . (scalar @hosts) . " < $num_nodes)";
}

our @logins;

for (my $i=0; $i<$num_nodes; $i++) {
    push @logins, "$USERNAME\@$hosts[$i]:$hosts[$i]";
}
my ($login, $host, $dir) = ($SAVEDIR =~ /^(\w+)\@([^:]+):(.*)$/);
if (!$login || !$host || !$dir) {
	tdie "invalid savedir: $SAVEDIR";
}
if ($DELETE_OLD_LOGS) {
    tinfo " deleting old logs on the $login\@$host ";
    rsystem($login, $host, sub {
	my $dir = shift;
	my @logs = glob("$dir/*");
	tinfo ("deleting " . scalar (@logs) . " logs\n");
	unlink @logs;
    }, $dir);
}

getlogs:
tinfo "* collecting log files to $SAVEDIR";
my $MAX_PARALLEL_RSYNCS = 10;
for (my $i=0; $i<@logins; $i += $MAX_PARALLEL_RSYNCS) {
    my $begin = $i;
    my $end   = $i+$MAX_PARALLEL_RSYNCS-1 > $#logins ? $#logins : $i+$MAX_PARALLEL_RSYNCS-1;

    ParallelExec2(sub {
	my $pref = shift;
	$pref =~ s/:.*$//;
	my ($user, $host) = split(/@/, $pref);
	
	rsystem($user, $host, sub {
	    my ($pref, $LOGDIR, $SAVEDIR) = @_;
	    my $stat = psystem("rsync -v -e ssh -azb $LOGDIR/* $SAVEDIR 1>&2");
	    if ($stat) {
		twarn "rsync of $pref:$LOGDIR failed! not deleting logs!";
	    } else {
		# now delete them
		psystem("rm -f $LOGDIR/*");
	    }
	}, $pref, $LOGDIR, $SAVEDIR);

    }, @logins[$begin..$end]);
}

