#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k $opt_o $opt_y);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NCko:y:");

our $APPCONF       = "TestgameConf.pl";

# defaults
our $MODE          = "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "lan-30";
our $MAX_NODES     = defined $opt_n ? $opt_n : 30;
# virtual time (exp time *= slowdown)
our $TIME_LIM      = defined $opt_t ? $opt_t : 8*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 5;
our $BOTS          = defined $opt_b ? $opt_b : 8;
our $SLOWDOWN      = defined $opt_y ? $opt_y : 1;
our $SLSTR = "$SLOWDOWN"; $SLSTR =~ s/\./-/;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;
our $KILL          = defined $opt_k;
our $OTHER_ARGS    = " -y '$SLOWDOWN' -B -Z "; # to RunV2.pl  (dont run with sudo) -s 

our $OUTPUTOPT = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "_emulab.exp.status";

our ($PUSH_USER, $PUSH_HOST);
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    rsystem ($PUSH_USER, $PUSH_HOST, sub { psystem ($_[0]); }, $cmd);
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################
# our @NODES = (3, 50, 40, 30, 25, 20, 15, 10, 5, 1);
# our @NODES = (1, 5, 10, 20, 30, 40, 50);
our @NODES = (1, 5, 10, 20, 30);

# our @P2P_NODES = ("1:5", "2:5", "1:20", "3:20",
#	"5:20", "10:20", "25:20", "50:20");
our @P2P_NODES = ("1:5", "1:20", "3:20",
	"5:20", "10:20", "25:20");

our @AVAIL_MAPS = ( 100, 10000, 1024, 144, 16, 1600, 196, 2025, 2500, 256, 324, 36, 3600, 4,
	400, 4900, 64, 6400, 784, 8100 );

@AVAIL_MAPS = sort { $a <=> $b } @AVAIL_MAPS;

# run_expt ("fed-dht-rect", "dht-rct-nodes");
@NODES = (20);
run_expt ("fed-dht-sqr", "dht-sqr-nodes");
# run_expt ("p2p-dht-sqr", "dht-sqr-p2p");

sub run_expt($$) {
    my ($type, $odir) = @_;
    my $realtime = $TIME_LIM*$SLOWDOWN;
    my $waitfor  = $realtime;
    my $timemsec = $realtime * 1000;

    my $map = "maps";
    $map = "rect_maps" if ($type =~ /rect/);
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    my $cmd = "./emulab/EmulabRun.pl -e utah -E '$MODE' -v %d -I '$IGNORE_NODES' -t '$waitfor' -o '$OUTPUTOPT/$odir/%d' ";
    $cmd .= " $APPCONF $EXP_NAME %d -e $timemsec -m $map/%d-players -b '%d' ";

    if ($type =~ /fed/) {
	for (my $i=0; $i<@NODES; $i++) {
	    my $n = $NODES[$i];
	    my $nservers = $n*$VSERVERS;
	    my $mapsize = get_map ($n, $VSERVERS, $BOTS);

	    my $fcmd = sprintf ($cmd, $VSERVERS, $nservers, $n, $mapsize, $BOTS);
	    $fcmd .= get_dht_command ($type, $mapsize);
	    $fcmd .= " $OTHER_ARGS ";
	    
	    exp_psystem ("$odir/$nservers", $fcmd);
	}
    }
    else {
	for (my $i=0; $i<@P2P_NODES; $i++) {
	    my $ns = $P2P_NODES[$i];
	    my ($n, $v) = split (/:/, $ns);
	    my $nservers = $n*$v;
	    my $mapsize = get_map ($n, $v, 1);	    

	    my $fcmd = sprintf ($cmd, $v, $nservers, $n, $mapsize, 1);
	    $fcmd .= get_dht_command ($type, $mapsize);
	    $fcmd .= " $OTHER_ARGS ";

	    exp_psystem ("$odir/$nservers", $fcmd);
	}
    }
}

print STDERR " ---------- DONE! ---------- \n";
exit 0;

###############################################################################
sub get_dht_command ($$) {
    my ($type, $mapsize) = @_;
    if ($type !~ /dht/) { 
	return "";
    }
    
    my $dhtsize;
    if ($type =~ /rect/) { 
	$dhtsize = $mapsize / 4;
    }
    else {
	$dhtsize = int (sqrt ($mapsize));
    }

    return " -D $dhtsize ";
}	

sub get_map ($$$) {
    my ($n, $v, $k) = @_;
    my $p = $n * $v * $k;

    foreach my $m (@AVAIL_MAPS) {
	if ($m >= $p) {
	    print "choose map with $m players for actually $p players\n";
	    return $m;
	}
    }
    return undef;
}

