#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_E $opt_v $opt_b $opt_C $opt_k $opt_o $opt_y);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NCko:y:");

our $APPCONF       = "TestgameConf.pl";

# defaults
our $MODE          = "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "defrag24";
our $MAX_NODES     = defined $opt_n ? $opt_n : 30;
# virtual time (exp time *= slowdown)
our $TIME_LIM      = defined $opt_t ? $opt_t : 8*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 5;
our $BOTS          = defined $opt_b ? $opt_b : 8;
our $SLOWDOWN      = defined $opt_y ? $opt_y : 3;
our $SLSTR = "$SLOWDOWN"; $SLSTR =~ s/\./-/;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;
our $KILL          = defined $opt_k;
our $OTHER_ARGS    = " -y '$SLOWDOWN' -B -Z "; # to RunV2.pl  (dont run with sudo) -s 

our $OUTPUTOPT = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "_emulab.exp.status";

our ($PUSH_USER, $PUSH_HOST);
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

psystem("echo -n > $STATUSFILE");

###############################################################################
our @NODES = ("2:3", "7:4", "10:5", "24:4", "30:5");
our @P2P_NODES = ("3:3", "5:5", "8:8", "10:10", "15:15", "26:20");

our @AVAIL_MAPS = map { $_ =~ s/-players//; $_; } split (/\n/, `ls ../../Data/rect_maps`); 
@AVAIL_MAPS = sort { $a <=> $b } @AVAIL_MAPS;

#$OUTPUTOPT = "jeffpang\@gs3078.sp.cs.cmu.edu:/usr1/jeffpang/nsdi2006";
#$OUTPUTOPT = "ashu\@iris-d-02.cmcl.cs.cmu.edu:/misc/ashu/nsdi2006-new/150-slow";
#($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

#my @PUB_INTERVALS = (100, 10000);
#run_expt ("fed-rect-pubtrig-off", "5:5", "fed-rct-25-pubtrig-off-test", @PUB_INTERVALS);
#run_expt ("fed-rect-pubtrig-on", "5:5", "fed-rct-25-pubtrig-on-test", @PUB_INTERVALS);
#my @SUB_PREDICTION = (10, 100, 10000);
#run_expt ("fed-rect-pubtrig", "5:5", "fed-rct-25-subpred-test", @SUB_PREDICTION);
#exit 0;

my @PFUDGE = ( 0, 100, 500, 1000, 5000 );
run_expt ("fed-rect-pfudge", "10:5", "fed-rct-50-pfudge", @PFUDGE);

@PFUDGE = ( 300, 10000, 20000, 2500, 750 );
run_expt ("fed-rect-pfudge", "10:5", "fed-rct-50-pfudge", @PFUDGE);

#{
#my @PUB_INTERVALS = (1000, 100, 5000);
#run_expt ("fed-rect-pubtrig-off", "10:5", "fed-rct-50-pubtrig-off", @PUB_INTERVALS);
#run_expt ("fed-rect-pubtrig-on", "10:5", "fed-rct-50-pubtrig-on", @PUB_INTERVALS);

#my @SUB_PREDICTION = (2500, 5000, 7500, 10000, 15000, 20000);
#run_expt ("fed-rect-subpred", "10:5", "fed-rct-50-subpred", @SUB_PREDICTION);
#}
#{
#my @PUB_INTERVALS = (10000, 20000, 500);
#run_expt ("fed-rect-pubtrig-off", "10:5", "fed-rct-50-pubtrig-off", @PUB_INTERVALS);
#run_expt ("fed-rect-pubtrig-on", "10:5", "fed-rct-50-pubtrig-on", @PUB_INTERVALS);

#my @SUB_PREDICTION = (10000, 20000, 500);
#run_expt ("fed-rect-subpred", "10:5", "fed-rct-50-subpred", @SUB_PREDICTION);
#}

sub run_expt($$$@) {
    my ($type, $ns, $odir, @vary) = @_;
    my $realtime = $TIME_LIM*$SLOWDOWN;
    my $waitfor  = $realtime;
    my $timemsec = $realtime * 1000;

    my $map = "maps";
    $map = "rect_maps" if ($type =~ /rect/);
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");
    my $cmd = "./emulab/EmulabRun.pl -e utah -E '$MODE' -v %d -I '$IGNORE_NODES' -t '$waitfor' -o '$OUTPUTOPT/$odir/%d' ";
    $cmd .= " $APPCONF $EXP_NAME %d -e $timemsec -m $map/%d-players -b '%d' ";

    if ($type =~ /fed/) {
	foreach my $vary (@vary) {
	    my ($n, $v) = split (/:/, $ns);
	    my $nservers = $n*$v;
	    my $mapsize = get_map ($n, $v, $BOTS);
	    
	    my $fcmd = sprintf ($cmd, $v, $vary, $n, $mapsize, $BOTS);
	    $fcmd .= get_dht_command ($type, $mapsize);
	    $fcmd .= get_pub_command ($type, $vary);
	    $fcmd .= get_sub_command ($type, $vary);
	    $fcmd .= get_dislat_command ($type, $vary);
	    $fcmd .= " $OTHER_ARGS ";
	    
	    tinfo "$fcmd";
	    exp_psystem ("$odir/$vary", $fcmd);
	}
    }
    else {
	foreach my $vary (@vary) {
	    my ($n, $v) = split (/:/, $ns);
	    my $nservers = $n*$v;
	    my $mapsize = get_map ($n, $v, 1);	    
	    
	    my $fcmd = sprintf ($cmd, $v, $nservers, $n, $mapsize, 1);
	    $fcmd .= get_dht_command ($type, $mapsize);
	    $fcmd .= get_pub_command ($type, $vary);
	    $fcmd .= get_sub_command ($type, $vary);
	    $fcmd .= get_dislat_command ($type, $vary);
	    $fcmd .= " $OTHER_ARGS ";
	    
	    tinfo "$fcmd";
	    exp_psystem ("$odir/$vary", $fcmd);
	}
    }
}

print STDERR " ---------- DONE! ---------- \n";
exit 0;

###############################################################################

sub get_dislat_command($$) {
    my $type = shift;
    my $vary = shift;
    my $ret = "";

    if ($type !~ /pfudge/) {
        return $ret;
    }

    $ret .= " --subpred 1000 ";
    $ret .= " --maxdislat $vary ";

    return $ret;
}

sub get_pub_command($$) {
    my $type = shift;
    my $vary = shift;
    my $ret = "";

    if ($type !~ /pubtrig/) {
	return $ret;
    }
    
    if ($type =~ /off/) {
	$ret .= " --nopubtriggers ";
    }

    $ret .= " --pubinterval $vary ";

    return $ret;
}

sub get_sub_command($$) {
    my $type = shift;
    my $vary = shift;
    my $ret = "";

    if ($type !~ /subpred/) {
	return $ret;
    }
    
    $ret .= " --subpred $vary ";

    return $ret;
}

sub get_dht_command ($$) {
    my ($type, $mapsize) = @_;
    if ($type !~ /dht/) { 
	return "";
    }
    
    my $dhtsize;
    if ($type =~ /rect/) { 
	$dhtsize = $mapsize / 4;
    }
    else {
	$dhtsize = int (sqrt ($mapsize));
    }

    return " -D $dhtsize ";
}	

sub get_map ($$$) {
    my ($n, $v, $k) = @_;
    my $p = $n * $v * $k;

    foreach my $m (@AVAIL_MAPS) {
	if ($m >= $p) {
	    print "choose map with $m players for actually $p players\n";
	    return $m;
	}
    }
    return undef;
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout-jeff/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout-jeff/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout-jeff/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

sub special_psystem($) {
    my $cmd = shift;
    
    rsystem ($PUSH_USER, $PUSH_HOST, sub { psystem ($_[0]); }, $cmd);
}

###############################################################################
