#!/usr/bin/perl
#
# Run a series of experiment trials on emulab
#

use strict;
use Getopt::Std;
use vars qw($opt_n $opt_t $opt_e $opt_E $opt_v $opt_b $opt_C $opt_k $opt_o $opt_y);
use lib "./emulab";
use Travertine;
use EmulabConf;

getopts("n:t:E:v:b:NCko:y:e:");

our $APPCONF       = "TestgameConf.pl";

# defaults
our $MODE          = defined $opt_e ? $opt_e : "";
our $EXP_NAME      = defined $opt_E ? $opt_E : "lan-30";
our $MAX_NODES     = defined $opt_n ? $opt_n : 30;
# virtual time (exp time *= slowdown)
our $TIME_LIM      = defined $opt_t ? $opt_t : 8*60;
our $VSERVERS      = defined $opt_v ? $opt_v : 5;
our $BOTS          = defined $opt_b ? $opt_b : 8;
our $SLOWDOWN      = defined $opt_y ? $opt_y : 1;
our $SLSTR = "$SLOWDOWN"; $SLSTR =~ s/\./-/;

our $IGNORE_NODES  = "";
our $CHECK_ONLY    = defined $opt_C;
our $KILL          = defined $opt_k;
our $OTHER_ARGS    = " -y '$SLOWDOWN' -B -Z "; # to RunV2.pl  (dont run with sudo) -s 

our $OUTPUTOPT = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR";
our $STATUSFILE = "_emulab.exp.status";

our ($PUSH_USER, $PUSH_HOST);
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

psystem("echo -n > $STATUSFILE");

sub special_psystem($) {
    my $cmd = shift;
    
    rsystem ($PUSH_USER, $PUSH_HOST, sub { psystem ($_[0]); }, $cmd);
}

sub exp_psystem($$) {
    my $name = shift;
    my $cmd  = shift;
    
    if ($CHECK_ONLY) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -C/;
    }
    if ($KILL) {
	$cmd =~ s/EmulabRun.pl/EmulabRun.pl -k/;
    }
    
    my $MAX_RETRIES = 1;
    my $retries = $MAX_RETRIES;
    my $iter = 0;
 
    tinfo "## $name ...";

    psystem ("mkdir -p /tmp/trialsout/$name");

    my $out;

    if (0) {
	for (my $iter = 0; $iter < 2; $iter++) { 
	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -1 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    else {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-succes.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-success.$iter'");
	    }
	}
    }

    if (1) {
	while ($out !~ /ok/ && $retries > 0) {
	    tinfo "PREVIOUS RUN of $name FAILED: RETRYING..." if $retries < $MAX_RETRIES;

	    special_psystem("mkdir -p '$PUSHLOGDIR/$name'");
	    my $opf = "/tmp/trialsout/$name/out.$iter";

	    psystem ("$cmd 2>&1 | tee $opf");
	    if ($? & 127) { 
		tdie sprintf ("received signal %d during execution", $? & 127);
	    }

	    $out  = `tail -2 $opf`;
	    chomp $out;

	    if ($out !~ /ok/) {
		special_psystem("rm -rf '$PUSHLOGDIR/$name-failed.$iter'");
		special_psystem("mv '$PUSHLOGDIR/$name' '$PUSHLOGDIR/$name-failed.$iter'");
	    }
	    $retries--;	
	    $iter++;
	}
    }
    open(S, ">>$STATUSFILE") || die "can't open $STATUSFILE: $!";
    print S "$name\t$out\n";
    close(S);
}

###############################################################################

our @NODES = ("2:3", "7:4", "10:5", "24:4", "30:5");
our @P2P_NODES = ("3:3", "5:5", "8:8", "10:10", "15:15", "26:20");

our @AVAIL_MAPS = map { $_ =~ s/-players//; $_; } split (/\n/, `ls ../../Data/rect_maps`); 
@AVAIL_MAPS = sort { $a <=> $b } @AVAIL_MAPS;

$OUTPUTOPT = "ashu\@iris-d-05.cmcl.cs.cmu.edu:/misc/ashu/nsdi2006-new/migrate-slow";
($PUSH_USER, $PUSH_HOST, $PUSHLOGDIR) = ($OUTPUTOPT =~ /^([^\@]+)\@([^:]+):(.*)/);

@NODES = ("24:4");
# various kinds of migration
if (1) {
    ## vary number of nodes

    my $odir = "migrate";
    
    special_psystem("mkdir -p '$PUSHLOGDIR/$odir'");

    my @policies = ("load2", "load1", "static", "region", "rand");
	
    foreach my $m ("load2", "static")
    {
	for (my $i=0; $i<@NODES; $i++) {
	    my $ns = $NODES[$i];
	    my ($n, $v) = split (/:/, $ns);
	    my $nservers = $n*$v;

	    my $realtime = $TIME_LIM*$SLOWDOWN;
	    my $waitfor  = $realtime;
	    my $timemsec = $realtime * 1000;
	    my $mapsize = get_map ($n, $v, $BOTS);
	    my $dhtsize = $mapsize / 4;    # 16player-map => 4 aoi's ;
	    my $pol;
	    my $extra;

	    if ($m eq "load1") {
		$pol = "load";
		$extra = "-I -R";
	    } elsif ($m eq "load2") {
		$pol = "load";
		$extra = "-I";
	    } else {
		$pol = $m;
		$extra = "-I";
	    }

	    exp_psystem("$odir/$m",
		    "./emulab/EmulabRun.pl -e utah " .
		    "-E '$MODE' " .
		    "-v '$v' " .
		    "-I '$IGNORE_NODES' " .
		    "-t '$waitfor' " .
		    "-o '$OUTPUTOPT/$odir/$m' " .
		    "$APPCONF $EXP_NAME $n " .
		    "-e $timemsec -m rect_maps/$mapsize-players -Q '$pol' -b '$BOTS' $OTHER_ARGS $extra");
	}
    }
}

###############################################################################

sub get_map ($$$) {
    my ($n, $v, $k) = @_;
    my $p = $n * $v * $k;

    foreach my $m (@AVAIL_MAPS) {
	if ($m >= $p) {
	    print "choose map with $m players for actually $p players\n";
	    return $m;
	}
    }
    return undef;
}

done:
## done!
print STDERR " ---------- DONE! ---------- \n";
exit 0;
