#!/usr/bin/perl
#
# Dependencies:
#
# * latest python scripts from: http://www.emulab.net/downloads/xmlrpc/
# * m2crypto
#
# Goto My Emulab -> User Options -> Generate SSL Cert
#
# It forces you to insert a password for the private key, but you
# can remove it using:
#
# openssl rsa -in emulab.pem -out emulab-clear.pem
#
# Copy the public cert block into emulab-clear.pem.
#
# Jeff: Not sure what happened to the ssh version of script_wrapper.py
# but the old version no longer works so we have to use the SSL one. :P
#
###############################################################################

use strict;
use lib "./emulab";
use Travertine;
use EmulabConf;
use Getopt::Std;

our $xmlrpc = "./emulab/script_wrapper.py";

sub GetExperimentNodeMapping ($$) {
    my $emulab = shift;
    my $exp = shift;
    my $cmd = "$xmlrpc --server=boss.$emulab --login=$USERNAME ";
    $cmd .= " expinfo -m -e $GROUP,$exp" ;

    open F, "$cmd | ";
    $_ = <F>;
    if ($_ =~ /No such experiment/) { 
	tdie "The experiment $exp has not been created on $emulab";
    }
    if ($_ =~ /No information available/) { 
	tdie "The experiment $exp has not been swapped in yet";
    }

    $_ = <F>;
    my ($state) = ($_ =~ /State: (\w+)/);
    
    if ($state eq 'swapped') { 
	tdie "The experiment $exp is currently swapped on $emulab";
    }

    foreach (1 .. 4) { $_ = <F>; }

    my %ret = ();
    while (<F>) { 
	chomp; 
	next if /^\s*$/;
	my ($node, $pc);
	($node, undef, undef, $pc) = split(/\s+/, $_);
	$ret{$node} = $pc;
    }

    return %ret;
}

1;
