#!/usr/bin/perl
#
# $Id: RunBatchExp.pl 2117 2005-09-01 20:49:06Z ashu $
#
# This script will be called from the emulab-batch script
# to run the actual experiment. Modify the script here, 
# commit it, and then queue the batch experiment. Of course,
# you can commit it any number of times before the batch 
# experiment runs! 

BEGIN {
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    $ENV{TRAVERTINE_PRINTCMDS} = 1;
}

use strict;
use Getopt::Std;
use vars qw($opt_e $opt_E $opt_k $opt_l $opt_v $opt_n $opt_P $opt_b $opt_y $opt_s $opt_o $opt_t $opt_M $opt_D $opt_R);

use lib "./emulab";
use EmulabConf;
use Travertine;

our @AVAIL_MAPS = ( 100, 10000, 1024, 144, 16, 1600, 196, 2025, 2500, 256, 324, 36, 3600, 4,
	400, 4900, 64, 6400, 784, 8100 );

getopts ("e:E:klv:n:P:b:y:so:t:DRM");

our $EMULAB = defined $opt_e ? $opt_e : "utah";
our $EXP_NAME = $opt_E;
our $KILL = $opt_k;
our $GETLOGS = $opt_l;
our $MAINDIR = defined $opt_P ? $opt_P : "nodes";
our $BOTS = defined $opt_b ? $opt_b : 8;
our $SLOWDOWN = defined $opt_y ? $opt_y : "0";
our $RUNWITHSUDO = defined $opt_s;
our $DHT = defined $opt_D;
our $MIGRATE = defined $opt_M;
our $REGION = defined $opt_R;

die "no expt name given (specify option -E)" if !defined $EXP_NAME;
our $VSERVERS = defined $opt_v ? $opt_v : 5;
our $NODES = defined $opt_n ? $opt_n : 10;
our $TIMELIMIT = defined $opt_t ? $opt_t : 700;

if ($SLOWDOWN > 1) {
    $TIMELIMIT = int ($TIMELIMIT * $SLOWDOWN);
}

our $SAVEDIR = defined $opt_o ? $opt_o : "$PUSHLOGHOST:$PUSHLOGDIR/$MAINDIR";
our $WAITTIME = $TIMELIMIT * 1000;   # EmulabRun adds some slack;

my $MAPSIZE = get_map ($NODES, $VSERVERS, $BOTS);
    
my $run_args = "-e $EMULAB -v $VSERVERS -t $TIMELIMIT -o $SAVEDIR ";
$run_args .= " -k " if $KILL;
$run_args .= " -l " if $GETLOGS;
$run_args .= " -s " if $RUNWITHSUDO;

my $lat_args = "-A";
if ($EMULAB eq "utah") {
    $lat_args = "-a n50.v20.lat";
}
my $game_args = " $lat_args -m rect_maps/$MAPSIZE-players -e $WAITTIME -b $BOTS ";
$game_args .= " -y $SLOWDOWN " if ($SLOWDOWN > 1);
$game_args .= " -D $MAPSIZE " if ($DHT);
$game_args .= " -Q load -I -R " if ($MIGRATE);
$game_args .= " -Q region " if ($REGION);

psystem ("./emulab/EmulabRun.pl $run_args TestgameConf.pl $EXP_NAME $NODES $game_args");

sub get_map ($$$) {
    my ($n, $v, $k) = @_;
    my $p = $n * $v * $k;

    @AVAIL_MAPS = sort { $a <=> $b } @AVAIL_MAPS;
    foreach my $m (@AVAIL_MAPS) {
	if ($m >= $p) {
	    print "choose map with $m players for actually $p players\n";
	    return $m;
	}
    }
    return undef;
}
